C Preprocessor for DieCAST model, island problem.              May, 2004
C from original October, 1993 version
C UNIFORM CARTESIAN grid.
C 2-dimensional version (density redundant)
C ----------------------------------------------------------------------
      BLOCK DATA NISHAL
C ----------------------------------------------------------------------
      CHARACTER CASE*5,DSCRIB*63
      INCLUDE '../resolution.h'
      PARAMETER(IJ0=I0+J0,IJ1=IJ0-1,I1=I0-1,I2=I0-2,I3=I0-3,J1=J0-1,
     1 J2=J0-2,J3=J0-3,K1=K0-1,K2=K0-2,NB1=NB0-1)
      COMMON/CONTRO/
     1 DT,TLZ,ZTOP,DM0,DE0,DMZ0,TAU,TAUN,FLTW,AV,
     2 DAODT,X0DEG,Y0DEG,DXDEG,DYDEG,LRSTRT,MXIT,LOPEN,
     3 LWIND,LMOVI,LEVP
      COMMON/LPI/M2,M6,MVI,IE(NB0)
      COMMON/TITLE/CASE,DSCRIB
      COMMON/ZFS/Z(K0+K1),ODZ(K1),ODZW(K0)
      DATA CASE/'ile0 '/
      DATA DSCRIB/
     1'base case island wake model                                    '/
      DATA TLZ,ZTOP/2.E5,1.E5/
      DATA DAODT,DM0,DE0,DMZ0,FLTW/
C eddy shedding
     A  72.,2.000E5,2.000E5,1.,.1/
c not eddy shedding
c    A  72.,5.128E6,5.128E6,1.,.1/
C    A 144.,4.875E6,4.875E6,1.,.1/
      DATA LRSTRT,MXIT/0,12960/
C Initial and boundary condition flags
      DATA LOPEN/1/
C Physical process flags
      DATA LWIND/0/
C Other flags
      DATA LMOVI,LEVP/1,1/
C Output control
      DATA M2,M6/10,5/

C ----------------------------
C EXPLANATION OF PARAMETERS
C ----------------------------
C I0,J0: horizontal dimension parameters (includes ghost zones around
C entire model domain; climatological boundary values are stored in
C ghost zones)
C K0: vertical dimension parameter (number of layer interfaces, equal
C the number of layers or pressure levels plus 1, does not include ghost
C zone)
C NB0: number of EVP elliptic solver restart vectors, used to control
C solver roundoff error (decreases with increasing NB0)
C CASE=5-character case name
C DSCRIB=63-character case descriptor
C TLZ=maximum depth (real depths are truncated to this value)
C ZTOP=top pressure level
C
C note: a constant vertical grid expansion coefficient is determined by
C a Newton-Raphson iteration such that top pressure level is at ZTOP and
C bottom of layer #K1 is at depth TLZ (Z(2*K0-1)=TLZ)
C
C TAU=surface restoring time in days
C TAUN=lateral boundary restoring time in days
C DAODT=number of time steps per day (8640 steps per year with DAODT=24)
C B=thermal expansion coefficient when linear equation of state is used
C G=gravity
C DM0,DE0 are horizontal heat and momentum diffusivities (cm-cm/sec)
C FLTW=time filter coefficient on time filtered leapfrog method
C KTRM=thermocline level (used only for animation graphics)
C LRSTRT=flag to initialize from restart file; if LRSTRT=0, initial vel
C  is zero (but not necessarily boundary values)
C MXIT=last time step number of current run (last time step of previous
C run is saved on restart file)
C LOPEN=flag for open lateral boundaries (derive geostrophic inflows)
C LSURF=flag for including climatological top layer restoring
C      =0 means no restoring
C      =1 means TOP LAYER climatological restoring to Levitus
C      =2 stores climatological SURFACE T and S
C         for more sophisticated air-sea treatments
C LIBC =flag to derive model initial/boundary T, S, U, and V from
C  T, S, and PSI observations that are not at model z-levels,
C  rather than reading all initial/boundary data directly to model grid
C LSALT,LWIND
C  flags for salinity, turbulence submodel, wind forcing,surface heating,
C  and interior radiative heating
C LSAVE=flag to save restart file
C LMOVI=flag to save data for animation of the results
C LEVP=flag for this program to initialize elliptic solver data for the
C  given geometry and also to generate initial temperature and salinity
C  (using Poisson equation when lateral boundary values are specified)
C M2=DAYS BETWEEN DTEMP AND VKE DATA
C M6=DAYS BETWEEN XI PLOTS
C IE=array for EVP elliptic solver (controls roundoff error); IE(NB0)=J1
      END
C ----------------------------------------------------------------------
      PROGRAM PREP
C ----------------------------------------------------------------------
      INCLUDE '../resolution.h'
      PARAMETER(I1=I0-1,I2=I0-2,I3=I0-3,J1=J0-1,J2=J0-2,J3=J0-3,K1=K0-1,
     1 K2=K0-2)
      CHARACTER*1 SYM(11),KAR
      CHARACTER CASE*5,DSCRIB*63
      INTEGER*2 KB,KBM,IU0,IV0,IN,IU,IV,IW
      COMMON/CONTRO/
     1 DT,TLZ,ZTOP,DM0,DE0,DMZ0,TAU,TAUN,FLTW,AV,
     2 DAODT,X0DEG,Y0DEG,DXDEG,DYDEG,LRSTRT,MXIT,LOPEN,
     3 LWIND,LMOVI,LEVP
      COMMON/SCA/GB,DX,ODX,DY,ODY,ODT,PRN,OFLTW
      COMMON/TOPOG/KB(I0,J0),KBM(I0,J0),IU0(I0,J0),IV0(I0,J0),
     1 IN(I0,J0,K1),IU(I1,J0,K1),IV(I0,J1,K1),IW(I0,J0,K0)
      COMMON/ZFS/Z(K0+K1),ODZ(K1),ODZW(K0)
      COMMON/FIELDS/DEPTH(I0,J0)
      COMMON F(J2)
      COMMON/TITLE/CASE,DSCRIB
      DATA SYM/'0','1','2','3','4','5','6','7','8','9','+'/
      DIMENSION KAR(I0,J0)

      GB=G*B
C OUTPUT DATA FILES
C BASIC RUN DATA
 2    OPEN(9,file='DATA/RUNDATA',form='unformatted')
      OPEN(17,file='KBVIEW')
      OPEN(60,file='DATA/ZKB',form='unformatted')
 4    IF (LEVP.EQ.0) GO TO 5
      IF (LEVP.EQ.1) OPEN(99,file='DATA/EVP',form='unformatted')

C vertical z-levels (redundant for 2-d problem)
 5    Z(1)=0.
      Z(2)=.5*TLZ
      Z(3)=.5*TLZ
      Z(4)=.75*TLZ
      Z(5)=TLZ
C vertical metrics
      DO 7 K=1,K1
 7    ODZ(K)=1./(Z(2*K+1)-Z(2*K-1))
      DO 8 K=2,K1
 8    ODZW(K)=1./(Z(2*K)-Z(2*K-2))
 
C BARBADOS
C     Y0DEG=13.17
C no rotation (redundant for 2-d problem)
      Y0DEG=0.
      WRITE(17,18) I0,J0,X0DEG,Y0DEG,DXDEG,DYDEG
 18   FORMAT('LATITUDE(X) GRID DIMENSION: ',I3/
     1 'LONGITUDE(Y) GRID DIMENSION: ',I3/
     2 'SW CORNER AT ',F6.1,' DEG. LONGITUDE, ',F6.1,' DEG. LATITUDE'/
     3 'RESOLUTION: ',F5.3,' DEG. LONGITUDE, ',F5.3,' DEG. LATITUDE')

C DX is in km at this point
      DX=400./I2
      DY=400./J2
C depths in meters
      AA=2.2E3
      BB=.0003
      CC=.0003
      DO 20 J=2,J1
      YY=-200.+DY*(J+J2/4-1.5)
      DO 20 I=2,I1
      XX=-200.+DX*(I-1.5)
      TMP=SQRT(XX**2+YY**2)
      DEPTH(I,J)=.01*TLZ
 20   IF (TMP.LT.25.) DEPTH(I,J)=0.
      WRITE(17,23) (DEPTH(I,J0/4+2),I=2,I1)
      WRITE(17,23) (DEPTH(I0/2,J),J=2,J1)
 23   FORMAT(/(10F8.2))

C DETERMINE DEPTH ARRAY KB(I,J), NUMBER OF LAYERS AT PRESSURE POINT (I,J)
      DO 24 K=1,K1
      ZZ=.5*(Z(2*K-1)+Z(2*K+1))
      DO 24 J=2,J1
      DO 24 I=2,I1
C IF DEPTH IS GREATER THAN MID-LAYER (ZZ), INCREMENT KB BY 1
      L=100.*DEPTH(I,J)/ZZ
 24   KB(I,J)=KB(I,J)+MIN(1,L)

      CALL INITFS(DEPTH)
C WRITE VERTICAL COORDINATE AND BATHYMMETRY DATA TO FILE FOR DieCAST
 206  WRITE(60) TLZ,Z,ODZ,ODZW,KB,IN,IU,IV,IW,IU0,IV0
C CONVERT DEPTH TO KM
      DO 207 J=2,J1
      DO 207 I=2,I1
 207  DEPTH(I,J)=.001*DEPTH(I,J)
      WRITE(60) DEPTH
      stop1
      END
C ----------------------------------------------------------------------
      SUBROUTINE SETZW(K1,ZBOT,ZTOP,Z)
C ----------------------------------------------------------------------
      DIMENSION Z(*)
      K0=K1+1
C Z(K0+K1)=ZBOT
      K01=K0+K1
      Z(1)=0.
C SET TOP PRESSURE LOCATION (NEAR MIDDLE OF TOP LAYER)
      Z(2)=ZTOP
C INITIAL ZB
      ZB0=2*K1*ZTOP
      GX0=1.
      GX=1.1
      DGX=GX-GX0
      N=0
 15   N=N+1
      DZ=ZTOP
      DO 100 K=3,K01
      DZ=GX*DZ
 100  Z(K)=Z(K-1)+DZ
      ZB=Z(K01)
      ERROR=ZB-ZBOT
      SLOPE=(ZB-ZB0)/DGX
      DGX=-ERROR/SLOPE
      IF (ABS(ERROR).LT..00002*ZBOT) GO TO 50
      GX0=GX
      GX=GX0+DGX
      ZB0=ZB
      GO TO 15
 50   WRITE(*,51) GX,ZB,ZBOT
 51   FORMAT(//'NEWTON-RAPHSON CONVERGED GRID EXPANSION FACTOR = ',F8.5/
     1'EXACT DEPTH = ',1PE12.5,', MODEL BOTTOM DEPTH = ',1PE12.5)
      END
C ******************************
C ELLIPTIC SOLVER PREPROCESSOR *
C ******************************
C ----------------------------------------------------------------------
      SUBROUTINE PRE(AX,AY,BB,CX,CY,RINV,RINV1,H,IE,M0,M2,NBLK)
C ----------------------------------------------------------------------
      REAL*8 RINV,RINV1,H,RUN
      DIMENSION AX(M2,1),AY(M2,1),BB(M2,1),CX(M2,1),CY(M2,1),
     1 RINV(M2,M2,1),RINV1(M2,M2,1),H(M0,1),IE(1)
      JL=1
      NB=0
 100  NB=NB+1
      JH=IE(NB)
      JHP=JH+1
      JHM=JH-2
      JG=JL+1
      DO 250 NG=1,M2
      IG=NG+1
      DO 210 J=JL,JHP
      DO 210 I=1,M0
 210  H(I,J)=0.
      H(IG,JG)=1.
      IF (NB.EQ.1) GO TO 220
      DO 218 N=1,M2
 218  H(N+1,JL)=RINV1(NG,N,NB-1)*CY(IG-1,JG-2)
 220  DO 225 J=JL,JHM
      DO 225 I=1,M2
 225  H(I+1,J+2)=-(AX(I,J)*H(I,J+1)+AY(I,J)*H(I+1,J)+BB(I,J)*H(I+1,J+1)+
     1 CX(I,J)*H(I+2,J+1))/CY(I,J)
      J=JH-1
      DO 230 I=1,M2
 230  RINV(NG,I,NB)=AX(I,J)*H(I,J+1)+AY(I,J)*H(I+1,J)+BB(I,J)*
     1 H(I+1,J+1)+CX(I,J)*H(I+2,J+1)
      IF (NB.EQ.NBLK) GO TO 250
      J=IE(NB)
      DO 240 N=1,M2
 240  RINV(NG,N,NBLK)=H(N+1,J)
 250  H(IG,JG)=0.
      CALL MATINV(RINV(1,1,NB),M2)
      IF (NB.EQ.NBLK) RETURN
      DO 260 I=1,M2
      DO 260 J=1,M2
      RINV1(I,J,NB)=0.
      DO 260 K=1,M2
 260  RINV1(I,J,NB)=RINV1(I,J,NB)-RINV(I,K,NB)*RINV(K,J,NBLK)
      JL=JH
      GO TO 100
      END
C ----------------------------------------------------------------------
      SUBROUTINE MATINV(B,N)
C ----------------------------------------------------------------------
      INCLUDE '../resolution.h'
      PARAMETER(I2=I0-2)
      IMPLICIT REAL*8 (A-H,O-Z)
      DIMENSION B(N,*),B1(I2),B2(I2)
      N1=N-1
      DO 135 I=1,N1
      B1(1)=1./B(I,I)
      B(I,I)=1.0
      DO 112 J=1,N
 112  B(I,J)=B(I,J)*B1(1)
      IP1=I+1
      DO 120 IA=IP1,N
 120  B1(IA)=B(IA,I)
      DO 125 IA=IP1,N
 125  B(IA,I)=0.
      DO 127 J=1,N
 127  B2(J)=B(I,J)
      DO 135 IA=IP1,N
      DO 135 J=1,N
 135  B(IA,J)=B(IA,J)-B1(IA)*B2(J)
      B1(1)=1./B(N,N)
      B(N,N)=1.
      DO 140 J=1,N
 140  B(N,J)=B(N,J)*B1(1)
      DO 160 I=2,N
      DO 155 IB=1,I
 155  B1(IB)=B(IB,I)
      IM1=I-1
      DO 156 IB=1,IM1
 156  B(IB,I)=0.
      DO 157 J=1,N
 157  B2(J)=B(I,J)
      IM1=I-1
      DO 160 IB=1,IM1
      DO 160 J=1,N
 160  B(IB,J)=B(IB,J)-B1(IB)*B2(J)
      END
C ****************
C INITIALIZATION *
C ****************
C ----------------------------------------------------------------------
      SUBROUTINE INITFS(DEPTH)
C INITFS Initializes all controlling arrays and derived scalars
C(scalar control parameters are set in BLOCK DATA at start of this file)
C ----------------------------------------------------------------------
      INCLUDE '../resolution.h'
      PARAMETER(IJ0=I0+J0,IJ1=IJ0-1,I1=I0-1,I2=I0-2,I3=I0-3,J1=J0-1,
     1 J2=J0-2,J3=J0-3,K1=K0-1,K2=K0-2,NB1=NB0-1)
      REAL*8 RINV,RINV1,DUM0,DUM1,DUM2,X,H
      CHARACTER CASE*5,DSCRIB*63
      INTEGER*2 KB,KBM,IU0,IV0,IN,IU,IV,IW
      COMMON F(J2)
      COMMON/CONTRO/
     1 DT,TLZ,ZTOP,DM0,DE0,DMZ0,TAU,TAUN,FLTW,AV,
     2 DAODT,X0DEG,Y0DEG,DXDEG,DYDEG,LRSTRT,MXIT,LOPEN,
     3 LWIND,LMOVI,LEVP
      COMMON/SCA/GB,DX,ODX,DY,ODY,ODT,PRN,OFLTW
      COMMON/SEVP/RINV(I2,I2,NB0),RINV1(I2,I2,NB1),DUM0(I2,NB1),
     1 DUM1(I2),DUM2(I2),X(I0,J0),H(I0,J0),AL(I2,J2),AB(I2,J2),
     2 AC(I2,J2),AR(I2,J2),AT(I2,J2)
      COMMON/TOPOG/KB(I0,J0),KBM(I0,J0),IU0(I0,J0),IV0(I0,J0),
     1 IN(I0,J0,K1),IU(I1,J0,K1),IV(I0,J1,K1),IW(I0,J0,K0)
      COMMON/ZFS/Z(K0+K1),ODZ(K1),ODZW(K0)
      COMMON/LPI/M2,M6,MVI,IE(NB0)
      COMMON/TITLE/CASE,DSCRIB
      COMMON/GMX/IB1,IB2,JB1,JB2,JB3,JMOVI,DTDJ(K1),AROUT,SVYUC
      DIMENSION V(I0,J1,K1),V1(I0,J0,K1)
      DIMENSION TAVG(K1),SUMIN(K1),P(I0,J0,K1),DEPTH(I0,J0)
 
      DT=172800./DAODT
      ODT=1./DT
      X1DEG=X0DEG+I2*DXDEG
      Y1DEG=Y0DEG+J2*DYDEG
C Degrees to radians
      PI_180=3.141592654/180.
      DY=1.E5*DY
      TLY=J2*DY
      ODY=1./DY
C Mid-latitude TLX (needed for Cartesian option)
      TLX=1.E5*I2*DX
C -----------------------------
C CARTESIAN METRICS (CONSTANTS)
C -----------------------------
      DX=TLX/I2
      ODX=1./DX
      OFLTW=1.-FLTW
      OM5=1./M5
      M2=M2*DAODT
      M6=M6*DAODT
      MVI=.25*DAODT
      PRN=DE0/DM0
C ----------------------------
C SET CORIOLIS PARAMETER ARRAY
C ----------------------------
      OMEGA2=3.141592654/21600.
      PHI=Y0DEG
      DO 9 J=2,J1
      F(J-1)=OMEGA2*SIN(PI_180*PHI)
C9    PHI=PHI+DYDEG
C F-PLANE
 9    CONTINUE
C --------------------------
C DERIVE LAND/SEA FLAG ARRAY
C --------------------------
      DO 52 J=2,J1
      DO 52 I=2,I1
      IT=KB(I,J)
      IF (IT.NE.0) GO TO 50
      KB(I,J)=1
      GO TO 52
 50   DO 51 K=1,IT
 51   IN(I,J,K)=1
 52   CONTINUE

C RESET KB FOR USE AT BOTTOM DRAG LOCATIONS
      DO 62 J=2,J1
      DO 62 I=2,I1
      K=0
 61   K=K+1
      IF (IN(I,J,K).EQ.1.AND.K.NE.K0) GO TO 61
 62   KB(I,J)=MAX(1,K-1)
      DO 65 K=1,K1
      DO 64 J=1,J0
      DO 64 I=1,I1
 64   IU(I,J,K)=IN(I,J,K)*IN(I+1,J,K)
      DO 65 J=1,J1
      DO 65 I=1,I0
 65   IV(I,J,K)=IN(I,J,K)*IN(I,J+1,K)
      DO 75 K=1,K2
      DO 75 J=1,J0
      DO 75 I=1,I0
 75   IW(I,J,K+1)=IN(I,J,K)*IN(I,J,K+1)
      DO 76 J=2,J1
      DO 76 I=2,I2
      IU0(I,J)=IU(I,J,1)
 76   IU(I,J,1)=1
      DO 77 J=2,J2
      DO 77 I=2,I1
      IV0(I,J)=IV(I,J,1)
 77   IV(I,J,1)=1
C ----------------------------------
C SET INITIAL VERTICAL DIFFUSIVITIES
C ----------------------------------
      WRITE(9) CASE,DSCRIB,DT,TLX,TLY,TLZ,DM0,DE0,DMZ0,
     1 FLTW,DAODT,DXDEG,DYDEG,ODT,GB,DX,DY,ODX,ODY,OFLTW,PRN,
     2 LRSTRT,MXIT,M2,M6,LOPEN,LMOVI,MVI,F

      IF (LEVP.NE.1) RETURN

      NN=J2/NB0
      DO 250 N=1,NB0
 250  IE(N)=MIN(1+NN*N,J1)
      WRITE(*,251) IE(NB0),J1
 251  FORMAT('IE(NB0),J1=',2I4)
      IF (IE(NB0).GT.IE(NB1).AND.J1.LT.IE(NB1)+NN+1) GO TO 260
      WRITE(17,252) IE(NB1),J1
      WRITE(*,252) IE(NB1),J1
 252  FORMAT('IE(NB1),J1=',2I5,' not properly defined. '
     1 'Fix above DO 250 loop and restart.')
      stop1
 260  IE(NB0)=J1
C     stop2

C -------------------------------------------------
C PREPROCESSOR FOR ELLIPTIC SOLVER USED TO MAINTAIN
C INCOMPRESSIBILITY FOR RIGID-LID HYDROSTATIC FLOWS
C -------------------------------------------------
C First, do top layer (all water to regularize EVP domain)
      DZX=ODX**2/ODZ(1)
      DZY=ODY**2/ODZ(1)
      DO 280 J=1,J2
      DO 280 I=1,I2
      AL(I,J)=DZX
      AR(I,J)=DZX
      AB(I,J)=DZY
 280  AT(I,J)=DZY
      DO 285 J=1,J2
      AL(1,J)=0.
 285  AR(I2,J)=0.
      DO 286 I=1,I2
      AB(I,1)=0.
 286  AT(I,J2)=0.
C Pin down pressure
      AB(I2/2,1)=AB(I2/2,2)
C     AB(I2,1)=AB(I2,2)
      DO 294 J=1,J2
      DO 294 I=1,I2
 294  AC(I,J)=-AL(I,J)-AR(I,J)-AB(I,J)-AT(I,J)
      K=1
      DO 545 J=1,J0
 545  WRITE(17,547) (IN(I,J,K),I=1,I0)
 550  WRITE(17,546) K
 546  FORMAT('IN(I,J,',I2,')')
 547  FORMAT(82I1)
      WRITE(*,548)
 548  FORMAT('enter elliptic solver preprocessor')
      CALL PRE(AL,AB,AC,AR,AT,RINV,RINV1,H,IE,I0,I2,NB0)
      WRITE(99) AL,AR,AB,AT,AC,RINV,RINV1,IE
 
      IF (LOPEN.NE.1) RETURN

C specify open "southern" inflow
      ZK=2.5E-5
      VINFLO=40.
      DO 690 K=1,K1
      DO 690 I=2,I1
C southern inflow
      V(I,1,K)=VINFLO
C match initial outflow to inflow
c (outflow evolves in model)
      V(I,J1,K)=VINFLO
      V1(I,1,K)=VINFLOW
 690  V1(I,J0,K)=VINFLOW
      OPEN(61,FILE='DATA/inflow',form='unformatted')
      WRITE(61) V,V1,V1,V1
      END
