      PROGRAM XYPLOT
      INCLUDE '../resolution.h'
      PARAMETER(L0=120000,I1=I0-1,I2=I0-2,I3=I0-3,
     1 J1=J0-1,J2=J0-2,J3=J0-3,K1=K0-1,K2=K0-2,K3=K0-3)
      CHARACTER CASE*5,DSCRIB*63,FN*1,FNAME*30,FNAM*30,NAME*47
      INTEGER*2 NX1,NX2,NY1,NY2,NCN,IN,IN0,IN1
C PLOT WINDOW IS SCALED BY LOGICAL (GRID) COORDINATES
C ALL FIELDS ARE ASSUMED AT SCALAR CELL CENTERS
      COMMON/FIELDS/FLD(I0,J0),P(I0,J0),U(I0,J0),V(I0,J0),DUM(I0,J0,K0),
     1 IN(I0,J0,K1),IN0(I0,J0)
      COMMON/FIXED/ODX,ODY,Z(K0+K1),ODZ(K1),ODZW(K0)
      COMMON/LABELS/CASE
      COMMON/LINSAV/XLO,XHI,YLO,YHI,XCON,YCON,LINES,MAXCV,
     1 NX1(L0),NX2(L0),NY1(L0),NY2(L0),NCN(L0)
      COMMON/CON/TIME,FMIN,FMAX,IMN,JMN,IMX,JMX
      COMMON/DEPTH/IN1(I0,J0)
      DATA NINT,NFLT/10,2/
      DO 10 J=1,J0
      DO 10 I=1,I0
 10   IN0(I,J)=0
      DO 11 J=2,J1
      DO 11 I=2,I1
 11   IN0(I,J)=1
C
      OPEN(4,file='LINES')
C INPUT FIELD DATA
      OPEN(30,file='DATA',form='unformatted')
      OPEN(24,file='GRID',form='unformatted')
      OPEN(34,file='OBSTACLES',form='unformatted')
      OPEN(25,file='CONVEC',form='unformatted')
      REWIND 4
      REWIND 24
      REWIND 34
      REWIND 25
      REWIND 30
      READ(30) CASE,DSCRIB,LRSTRT,MXIT,I,J,K,IN,ODX,ODY,ODZ,Z

      WRITE(*,22) CASE,DSCRIB,I,J,K,.00001/ODX,.00001/ODY,
     1 (.01*Z(N),N=1,K0+K1,2)
      WRITE(4,22) CASE,DSCRIB,I,J,K,.00001/ODX,.00001/ODY,
     1 (.01*Z(N),N=1,K0+K1,2)
 22   FORMAT('Case ',A5/A63/'I0,J0,K0,ODX,ODY:',
     1 3I3,F5.1,' km,',F5.1,' km'/'layer interface depths (m)'/(10F8.2))

      IF (I.EQ.I0.AND.J.EQ.J0.AND.K.EQ.K0) GO TO 26
      WRITE(*,25) I,J,K
      WRITE(4,25) I,J,K
 25   FORMAT('STOP. SET DIMENSION PARAMETERS I0,J0,K0 TO',3(1X,I3))
      STOP0
 26   CALL FLUSH(4)
      XLO=0.
C     YLO=0.
C LEAVE LOWER 1/20 OF PLOT WINDOW FOR TEXT
      YLO=-J2/20.
      XHI=I2
      YHI=J2
      XCON=9999./(XHI-XLO)
      YCON=9999./(YHI-YLO)
      MAXCV=0
      LINES=0
      CALL GRID(0,0,I2,J2)
      WRITE(4,59) LINES
 59   FORMAT('M0= ',I6,' (LINES REQUIRED FOR GRID TICKS)')
      WRITE(24) LINES,(NX1(L),NX2(L),NY1(L),NY2(L),L=1,LINES)
      CLOSE(24)
C OBSTACLES
C OPTIONALLY, SMOOTH BORDER CAN BE DRAWN BY CONTOURING APPROPRIATE FLAG ARRAY
      MAXOB=0
      DO 80 K=1,K1
      LINES=0
      CALL BLOKS(K,3,3,I2,J2)
      WRITE(4,78) LINES,K
 78   FORMAT(I6,' LINES REQUIRED FOR LAYER ',I2,' OBSTACLES')
      WRITE(34) LINES,(NX1(L),NX2(L),NY1(L),NY2(L),L=1,LINES)
 80   MAXOB=MAX(LINES,MAXOB)
      WRITE(4,81) MAXOB
 81   FORMAT('L0= ',I5,' (LINES REQUIRED FOR OBSTACLES)')
      CLOSE(34)
      NPLOT=0
 100  LINES=0
      CALL INPUT(NPLOT,FLD,FN,K,FNAME)
C plot vorticity only
      IF (FN.NE.'s'.AND.ITF.NE.MXIT) GO TO 100

      FMIN0=FMIN
      FMAX0=FMAX
      ZLEV=.01*Z(2*K)

      IF (NFLT.EQ.0) GO TO 105
C     MFLT=NFLT
C     IF (FN.EQ.'s') MFLT=2
C     DO 101 N=1,MFLT
      DO 101 N=1,NFLT
C X-DIMENSION FILTER
      CALL FLTX(0.,FLD,DUM,IN(1,1,K))
C Y-DIMENSION FILTER
 101  CALL FLTY(0.,FLD,DUM,IN(1,1,K))
      FMAX=-1.E6
      FMIN=1.E6
      DO 1001 J=2,J1
      DO 1001 I=2,I1
      IF (IN(I,J,K).EQ.0) GO TO 1001
      FMAX=MAX(FLD(I,J),FMAX)
 1001 FMIN=MIN(FLD(I,J),FMIN)

CONTOURS
 105  IF (FN.EQ.'D'.OR.FN.EQ.'s'.OR.FN.EQ.'d'.OR.FN.EQ.'P'
     1 .OR.FN.EQ.'p'.OR.FN.EQ.'M'.OR.FN.EQ.'e'.OR.FN.EQ.'Z'.OR.FN.EQ.'X'
     2.OR.FN.EQ.'x'.OR.FN.EQ.'c'.OR.FN.EQ.'m'.OR.FN.EQ.'R') GO TO 110
      CALL CONXY
     1 (FLD,IN(1,1,K),.5,.5,I0,2,2,I1,J1,.001,5,5,FMIN,FMAX,10)
      GO TO 111
 110  IF (FN.EQ.'Z') CALL CONXY
     1 (FLD,IN,.5,.5,I0,2,2,I1,J1,.002,5,5,0.,6.,12)
      PDIF=FMAX
      IF (FN.EQ.'e') CALL CONXY
     1 (FLD,IN(1,1,K),.5,.5,I0,2,2,I1,J1,.001,5,5,0.,30.,30)
C SHOW CONTOUR LEVEL 300 AS '0', 325 AS '1'
      IF (FN.EQ.'D') CALL CONXY
     1 (FLD,IN1,.5,.5,I0,2,2,I1,J1,.002,5,5,0.,1000.,20)
      IF (FN.EQ.'p') CALL CONXY
     1 (FLD,IN0,.5,.5,I0,2,2,I1,J1,.001,5,5,-200.,200.,80)
      IF (FN.EQ.'s'.OR.FN.EQ.'d') CALL CONXY
     1 (FLD,IN(1,1,K),.5,.5,I0,2,2,I1,J1,.001,5,5,-200.,200.,40)
      IF (FN.EQ.'c') CALL CONXY
     1 (FLD,IN(1,1,K),.5,.5,I0,2,2,I1,J1,.001,5,5,-100.,100.,20)
      IF (FN.EQ.'X') CALL CONXY
     1 (FLD,IN(1,1,K),.5,.5,I0,2,2,I1,J1,.001,5,5,-20.,20.,80)
      IF (FN.EQ.'P'.OR.FN.EQ.'x') CALL CONXY
     1 (FLD,IN(1,1,K),.5,.5,I0,2,2,I1,J1,.001,5,5,-245.,245.,98)

      IF (FN.EQ.'M') CALL CONXY
     1 (FLD,IN(1,1,K),.5,.5,I0,2,2,I1,J1,.001,5,5,0.,20.,40)
      IF (FN.EQ.'m') CALL CONXY
     1 (FLD,IN(1,1,K),.5,.5,I0,2,2,I1,J1,.001,5,5,0.,100.,20)

 111  IF (FN.NE.'P'.AND.FN.NE.'R') GO TO 120
      PDIF=FMAX
C VELOCITY VECTORS WITH PRESSURE
      CALL INPUT(NPLOT,U,FN,K,FNAM)
      CALL INPUT(NPLOT,V,FN,K,FNAM)
      IF (NFLT.EQ.0) GO TO 115
      DO 114 N=1,NFLT
      CALL FLTX(0.,U,DUM,IN(1,1,K))
      CALL FLTY(0.,U,DUM,IN(1,1,K))
      CALL FLTX(0.,V,DUM,IN(1,1,K))
 114  CALL FLTY(0.,V,DUM,IN(1,1,K))

C VELOCITY VECTORS
 115  CALL VECPL(U,V,IN(1,1,K))
      FMIN=PMAX-PMIN
      FN='v'
 120  NPLOT=NPLOT+1
      MAXCV=MAX(LINES,MAXCV)
      WRITE(25)
     1 K,FN,FNAME,ZLEV,TIME,FMIN0,FMAX0,IMN,JMN,IMX,JMX,NINT,
     2 LINES,(NX1(L),NX2(L),NY1(L),NY2(L),NCN(L),L=1,LINES)
      CALL FLUSH(25)
      WRITE(*,200) NPLOT,MAXCV
 200  FORMAT('NPLOT,MAXCV',2I6)
      GO TO 100
      END
C ----------------------------------------------------------------------
      SUBROUTINE GRID(IL,JL,IH,JH)
C ----------------------------------------------------------------------
C THIS MODULE DRAWS RECTANGULAR BOUNDARY AND GRID TICK MARKS
      INCLUDE '../resolution.h'
      PARAMETER(L0=120000,I1=I0-1,I2=I0-2,I3=I0-3,
     1 J1=J0-1,J2=J0-2,J3=J0-3,K1=K0-1,K2=K0-2,K3=K0-3)
      DIMENSION XPT(5),YPT(5)
      XPT(1)=IL
      YPT(1)=JL
      XPT(2)=IH
      YPT(2)=JL
      XPT(3)=IH
      YPT(3)=JH
      XPT(4)=IL
      YPT(4)=JH
      XPT(5)=IL
      YPT(5)=JL
CPLT DRAW RECTANGULAR PLOT BOUNDARY (FOUR STRAIGHT LINES,
C LAST POINT = FIRST POINT)
      DO 4 L=1,4
 4    CALL GRAPH(XPT(L),YPT(L))
      JHM=JH-1
      IHM=IH-1
      ILP=IL+1
      JLP=JL+1
CPLT DRAW TICK MARKS ON PLOT BOUNDARY TO SHOW GRID SPACING
      TICK=1.
      YPT(1)=JL
      YPT(2)=JL+TICK
      YPT(3)=JH-TICK
      YPT(4)=JH
      DO 6 I=IL+2,IH,2
      XPT(1)=I
      XPT(2)=I
C Draw cross-grid longitudinal lines, every 30th point (exactly 5 deg)
      IF (MOD(I-IL,10).NE.0) GO TO 5
C this actually uses YPT(5)=JL=0.
      CALL GRAPH(XPT,YPT(4))
      GO TO 6
CPLT DRAW BOTTOM AND TOP TICK MARKS
 5    CALL GRAPH(XPT,YPT)
      CALL GRAPH(XPT,YPT(3))
 6    CONTINUE
      XPT(1)=IL
      XPT(2)=TICK
      XPT(3)=IH
      XPT(4)=IH-TICK
      DO 7 J=JLP,JHM,2
      YPT(1)=J
      YPT(2)=J
CPLT DRAW RIGHT AND LEFT TICK MARKS
      CALL GRAPH(XPT,YPT)
 7    CALL GRAPH(XPT(3),YPT)
      END
C ----------------------------------------------------------------------
      SUBROUTINE BLOKS(K,IL,JL,IH,JH)
C ----------------------------------------------------------------------
C THIS MODULE DRAWS STAIRCASE BOUNDARIES AND CROSS-HATCHES BLOCKED AREAS
C OPTIONALLY, STAIRCASE COULD BE DONE BY CONTOURING FLAG ARRAYS
      INCLUDE '../resolution.h'
      PARAMETER(L0=120000,I1=I0-1,I2=I0-2,I3=I0-3,
     1 J1=J0-1,J2=J0-2,J3=J0-3,K1=K0-1,K2=K0-2,K3=K0-3)
      INTEGER*2 IN,IN0
      COMMON/FIXED/ODX,ODY,Z(K0+K1),ODZ(K1),ODZW(K0)
      COMMON/FIELDS/FLD(I0,J0),P(I0,J0),U(I0,J0),V(I0,J0),DUM(I0,J0,K0),
     1 IN(I0,J0,K1),IN0(I0,J0)
      DIMENSION XPT(5),YPT(5)
C
      DO 18 J=JL,JH
      DO 18 I=IL,IH
C Skip huge cross-hatch storage
      GO TO 16
C CROSS-HATCH
      IF (IN(I,J,1).EQ.1) GO TO 16
      XPT(1)=I-IL+0.1
      YPT(1)=J-JL+0.1
      XPT(2)=XPT(1)+0.9
      YPT(2)=YPT(1)+0.9
      CALL GRAPH(XPT,YPT)
      TMP=YPT(1)
      YPT(1)=YPT(2)
      YPT(2)=TMP
      CALL GRAPH(XPT,YPT)
C STAIRCASE
 16   IF (IN(I,J,K)+IN(I,J+1,K).NE.1) GO TO 17
      XPT(1)=I-IL
      XPT(2)=XPT(1)+1.
      YPT(1)=J-JL+1.
      YPT(2)=YPT(1)
      CALL GRAPH(XPT,YPT)
 17   IF (IN(I,J,K)+IN(I+1,J,K).NE.1) GO TO 18
      XPT(1)=I-IL+1.
      XPT(2)=XPT(1)
      YPT(1)=J-JL
      YPT(2)=J-JL+1.
      CALL GRAPH(XPT,YPT)
 18   CONTINUE
      END
C ----------------------------------------------------------------------
      SUBROUTINE FLTX(PWT,P,S,IN)
C BIHARMONIC FILTER
C ----------------------------------------------------------------------
      INCLUDE '../resolution.h'
      PARAMETER(I1=I0-1,J1=J0-1,I2=I0-2)
      INTEGER*2 IN(I0,1)
      DIMENSION P(I0,1),S(I0,1)
      TMP=(1.-PWT)/16.
C PERIODIC OPTION
C     DO 40 J=2,J1
C     P(1,J)=P(I1,J)
C10   P(I0,J)=P(2,J)
      DO 40 J=2,J1
      DO 20 I=2,I1
 20   S(I,J)=IN(I,J)*(IN(I-1,J)*P(I-1,J)+IN(I+1,J)*P(I+1,J)
     1 -(IN(I-1,J)+IN(I+1,J))*P(I,J))
C PERIODIC OPTION
C     DO 30 J=2,J1
C     S(1,J)=S(I1,J)
C30   S(I0,J)=S(2,J)
C     DO 40 I=2,I1
      DO 40 I=3,I2
 40   P(I,J)=P(I,J)-TMP*IN(I,J)*(IN(I-1,J)*S(I-1,J)+IN(I+1,J)*S(I+1,J)
     1 -(IN(I-1,J)+IN(I+1,J))*S(I,J))
      END
C ----------------------------------------------------------------------
      SUBROUTINE FLTY(PWT,P,S,IN)
C BIHARMONIC FILTER
C ----------------------------------------------------------------------
      INCLUDE '../resolution.h'
      PARAMETER(I1=I0-1,J1=J0-1)
      INTEGER*2 IN(I0,1)
      DIMENSION P(I0,1),S(I0,1)
      TMP=(1.-PWT)/16.
      DO 40 I=2,I1
      DO 20 J=2,J1
 20   S(I,J)=IN(I,J)*(IN(I,J-1)*P(I,J-1)+IN(I,J+1)*P(I,J+1)
     1 -(IN(I,J-1)+IN(I,J+1))*P(I,J))
      DO 40 J=2,J1
 40   P(I,J)=P(I,J)-TMP*IN(I,J)*(IN(I,J-1)*S(I,J-1)+IN(I,J+1)*S(I,J+1)
     1 -(IN(I,J-1)+IN(I,J+1))*S(I,J))
      END
C ----------------------------------------------------------------------
      SUBROUTINE CONXY(FLD,IN,XBRD,YBRD,IR,IL,JL,IH,JH,EPS,IMSK,JMSK,
     1 RMIN,RMAX,NINT)
C ----------------------------------------------------------------------
C THIS MODULE CONTOURS HORIZONTAL (XY) CROSS-SECTIONS
      INCLUDE '../resolution.h'
      PARAMETER(L0=120000,I1=I0-1,I2=I0-2,I3=I0-3,
     1 J1=J0-1,J2=J0-2,J3=J0-3,K1=K0-1,K2=K0-2,K3=K0-3)
      PARAMETER(LB0=100)
      INTEGER*2 NX1,NX2,NY1,NY2,NCN,IN

C NINT < LBS dimension!
      CHARACTER*6 LBS(LB0)

      COMMON/SCRTCH/SCLN(I0,2)
      COMMON/SC/SEGMX(I0),SEGMN(I0),CELMX(I1),CELMN(I1),ZERO(I1),
     1 MXCEL(I1),MNCEL(I1)
      COMMON/LINSAV/XLO,XHI,YLO,YHI,XCON,YCON,LINES,MAXCV,
     1 NX1(L0),NX2(L0),NY1(L0),NY2(L0),NCN(L0)
      DIMENSION MASK(I0,J0),FLD(IR,1),IN(IR,1),XPT(5),YPT(5)

C ============
Contour labels
C ============
C Write LBS content (later use contour values based on RMIN,RMAX,NINT)
      IF (NINT.GT.LB0) stop0
      IF (RMAX-RMIN.LT.1.) GO TO 1
      IF (ABS(RMAX).LT.999..AND.ABS(RMIN).LT.999.) GO TO 5
C scaled labeling
C (6-character true value decimal labels are not precise or are too small)
 1    DO 2 N=1,NINT
 2    WRITE(LBS(N),3) N
 3    FORMAT(I2)
      GO TO 18
C true value labels
 5    TMP=RMIN
      TEMP=(RMAX-RMIN)/NINT
      DO 7 N=1,NINT
      TMP=TMP+TEMP
 7    WRITE(LBS(N),8) TMP
 8    FORMAT(F6.1)
 18   WRITE(25) NINT,(LBS(N),N=1,NINT)

      FNORM=NINT/(RMAX-RMIN)
      LZERO=0
      DO 19 J=JL,JH
      DO 19 I=IL,IH
 19   MASK(I,J)=0
      IHM=IH-1
      JHM=JH-1
      F0=-RMIN*FNORM
C STORE NORMALIZED BOTTOM ROW INTO SCLN (0.LT.SCLN.LT.NINT)
C CONTOURS ARE DRAWN FOR SCLN=1,2,...,NINT-1 AND ARE LABELED BY INTEGER VALUES
C A KEY THEN GIVES THE ACTUAL (UNNORMALIZED) VALUE OF THE CONTOUR
      DO 20 I=IL,IH
 20   SCLN(I,1)=(FLD(I,JL)-RMIN)*FNORM
      N21=1
      N22=2
C CONTOUR ROW BY ROW
      DO 1000 J=JL,JHM
      DO 21 I=IL,IH
 21   SCLN(I,N22)=(FLD(I,J+1)-RMIN)*FNORM
C CALCULATE MAX AND MIN OF EACH VERTICAL SEGMENT IN THE ROW
C ON SCALAR COMPUTERS USE SEGMX(I)=MAX(SCLN(I,1),SCLN(I,2))
      DO 26 I=IL,IH
      SEGMX(I)=SCLN(I,1)
      SEGMN(I)=SCLN(I,1)
      SEGMX(I)=MAX(SEGMX(I),SCLN(I,2))
 26   SEGMN(I)=MIN(SEGMN(I),SCLN(I,2))
C CALCULATE MAX AND MIN OF EACH CELL IN THE ROW
C ON SCALAR COMPUTERS USE CELMX(I)=MAX(SEGMX(I),SEGMX(I+1))
      DO 36 I=IL,IHM
      CELMX(I)=SEGMX(I)
      CELMN(I)=SEGMN(I)
      CELMX(I)=MAX(CELMX(I),SEGMX(I+1))
 36   CELMN(I)=MIN(CELMN(I),SEGMN(I+1))
C ELIMINATE POSSIBLE ROUNDOFF PROBLEMS IN CELL
C     R=CELMX(I)-CELMN(I)
C     N=MIN(R/1.E-3,1.)
C36   CELMX(I)=CELMN(I)+N*R
C     IF (LZERO.EQ.0) GO TO 38
C     DO 37 I=IL,IHM
C37   ZERO(I)=MAX(0.,(CELMX(I)-F0)*(CELMN(I)-F0))
C CONVERT MAX AND MIN TO CONTOUR INTERVAL NUMBER
 38   IF (XBRD.NE.0.) GO TO 41
      DO 40 I=IL,IHM
C VORTICITY POINTS (CELL CORNERS)
      N=IN(I+1,J+1)
C     ZERO(I)=ZERO(I)+2-N-LZERO
      MXCEL(I)=N*INT(CELMX(I))
 40   MNCEL(I)=N*INT(CELMN(I))
      GO TO 50
 41   DO 42 I=IL,IHM
C CELL-CENTERED POINTS
      N=IN(I,J)*IN(I+1,J)*IN(I,J+1)*IN(I+1,J+1)
C     ZERO(I)=ZERO(I)+2-N-LZERO
      MXCEL(I)=N*INT(CELMX(I))
 42   MNCEL(I)=N*INT(CELMN(I))
C CONTOURING LOOP FOR CURRENT ROW
 50   DO 100 I=IL,IHM
C NO CONTOURS ENTER CELL IF MXCEL.EQ.MNCEL
      IF (MXCEL(I).EQ.MNCEL(I)) GO TO 100
C     IF (MXCEL(I).EQ.MNCEL(I).AND.ZERO(I).NE.0.) GO TO 100
      ID=I-IL
      JD=J-JL
C STORE SOUTHWEST, SOUTHEAST, NORTHWEST, AND NORTHEAST GRID VALUES
      FSW=SCLN(I,N21)
      FSE=SCLN(I+1,N21)
      FNW=SCLN(I,N22)
      FNE=SCLN(I+1,N22)
C DO CONTOUR DRAWING ONLY FOR CONTOUR VALUES MNCEL+1,MNCEL+2,...,MXCEL
      NLO=MNCEL(I)+1
      NHI=MXCEL(I)
      NHIP=NHI
C     IF (ZERO(I).EQ.0..AND.LZERO.EQ.1) NHIP=NHI+1
      DO 90 N=NLO,NHIP
      R=REAL(N)
      IF (N.GT.NHI) R=F0
C USE LINEAR INTERPOLATION TO DETERMINE WHICH OF THE FOUR SIDES OF CELL(I,J) IS
C CROSSED BY THE NORMALIZED VALUE N CONTOUR, AND DRAW CONTOUR SEGMENTS.
C DETERMINE EACH CONTOUR INTERSECTION WITH CELL SIDES AND STORE IN (XPT,YPT).
      NPT=0
C CHECK SOUTH CELL SIDE
      IF (R.GE.MAX(FSW,FSE).OR.R.LE.MIN(FSW,FSE)) GO TO 52
      NPT=NPT+1
      XPT(NPT)=ID+(R-FSW)/(FSE-FSW)
      YPT(NPT)=JD
C CHECK NORTH CELL SIDE
  52  IF (R.GE.MAX(FNW,FNE).OR.R.LE.MIN(FNW,FNE)) GO TO 54
      NPT=NPT+1
      XPT(NPT)=ID+(R-FNW)/(FNE-FNW)
      YPT(NPT)=JD+1
C CHECK WEST CELL SIDE
  54  IF (R.GE.MAX(FSW,FNW).OR.R.LE.MIN(FSW,FNW)) GO TO 56
      NPT=NPT+1
      XPT(NPT)=ID
      YPT(NPT)=JD+(R-FSW)/(FNW-FSW)
C CHECK EAST CELL SIDE
  56  IF (R.GE.MAX(FSE,FNE).OR.R.LE.MIN(FSE,FNE)) GO TO 60
      NPT=NPT+1
      XPT(NPT)=ID+1
      YPT(NPT)=JD+(R-FSE)/(FNE-FSE)
C NORMALLY, ONLY ONE SEGMENT OF CONTOUR VALUE N WILL EXIST IN CELL.  IN SUCH
C CASE, THE CONTOUR CROSSES ONLY TWO SIDES OF CELL(I,J), AND NPT=2 HERE.
 60   IF (NPT.NE.2) GO TO 90
C CHECK FOR DASHED LINES
C 65   IF (R.NE.F0) GO TO 69
C      IF (R.NE.F0) GO TO 67
C LONG DASH ZERO LINE
C      XPT(1)=.5*(XPT(1)+XPT(2))
C      YPT(1)=.5*(YPT(1)+YPT(2))
C      GO TO 69
C67   IF (N.NE.NINT/2) GO TO 69
C SHORT DASH MEAN LINE
C     XPT(1)=.25*XPT(1)+.75*XPT(2)
C     YPT(1)=.25*YPT(1)+.75*YPT(2)
 69   DO 70 NPT=1,2
      XPT(NPT)=XPT(NPT)+XBRD
 70   YPT(NPT)=YPT(NPT)+YBRD
      XC=.5*(XPT(1)+XPT(2))
      YC=.5*(YPT(1)+YPT(2))
      IF (R.GE.F0) GO TO 75
C DASH NEGATIVE CONTOURS
      XPT(2)=XPT(1)+.75*(XPT(2)-XPT(1))
      YPT(2)=YPT(1)+.75*(YPT(2)-YPT(1))
CPLT DRAW SEGMENT CONNECTING (XPT(1),YPT(1)) TO (XPT(2),YPT(2)).
 75   CALL GRAPH(XPT,YPT)
      NCN(LINES)=N
      IF (MASK(I,J).EQ.1.OR.NLO.NE.NHIP) GO TO 90
      C=(XC-ID-1.)**2+(YC-JD-1.)**2
      IF (C.GT.EPS) GO TO 90
C TRIGGER FOR LABELS IS NEGATIVE VALUE OF NCN
      NCN(LINES)=-N
      JA=J
      JB=MIN(J+JMSK,JHM)
      IA=MAX(I-IMSK,IL)
      IB=MIN(I+IMSK,IHM)
      DO 80 JJ=JA,JB
      DO 80 II=IA,IB
 80   MASK(II,JJ)=1
 90   CONTINUE
 100  CONTINUE
      I=N21
      N21=N22
 1000 N22=I
      END
C ---------------------------------------------------------------------
      SUBROUTINE VECPL(U,V,IN)
C ---------------------------------------------------------------------
      INCLUDE '../resolution.h'
      PARAMETER(L0=120000,I1=I0-1,I2=I0-2,I3=I0-3,
     1 J1=J0-1,J2=J0-2,J3=J0-3,K1=K0-1,K2=K0-2,K3=K0-3)
      INTEGER*2 NX1,NX2,NY1,NY2,NCN,IN,NN(I0,J0)
      DIMENSION U(I0,*),V(I0,*)
      COMMON/FIXED/ODX,ODY,Z(K0+K1),ODZ(K1),ODZW(K0)
      COMMON/CON/TIME,FMIN,FMAX,IMN,JMN,IMX,JMX
      COMMON/LINSAV/XLO,XHI,YLO,YHI,XCON,YCON,LINES,MAXCV,
     1 NX1(L0),NX2(L0),NY1(L0),NY2(L0),NCN(L0)
      DIMENSION XS(I0),XE(I0),YS(I0),YE(I0),AX(I0),AY(I0),BX(I0),BY(I0),
     1 CX(I0),CY(I0),SEGMX(I0),X2PT(2,I0+K0),Y2PT(2,I0+K0),IN(I0,1)

      DO 2 J=1,J0
      DO 2 I=1,I0
 2    NN(I,J)=0

      JHM=JH-1
      V2MX=0.
      DO 5 J=2,J1
      DO 5 I=2,I1
 5    V2MX=MAX(V2MX,U(I,J)**2+V(I,J)**2)
      FMAX=SQRT(V2MX)
      DO 7 I=2,I1
 7    SEGMX(I)=MAX(ABS(U(I,2))*ODX,ABS(V(I,2)*ODY))
      DO 8 J=2,J2
      DO 8 I=2,I1
 8    SEGMX(I)=MAX(SEGMX(I),ABS(U(I,J+1)*ODX),ABS(V(I,J+1)*ODY))
      SMAX=SEGMX(1)
      DO 10 I=2,I1
 10   SMAX=MAX(SMAX,SEGMX(I))
      IF (SMAX.EQ.0.) RETURN
      SIZ=10.
      UNRM=SIZ/SMAX
CPLT DRAW VECTOR FROM POINT (XS(I),YS(I)) TO POINT (XE(I),YE(I))
C TIP=(TIP LENGTH)/(SHAFT LENGTH); WD=(TIP WIDTH)/(TIP LENGTH)
      TIP=.5
      WD=.5
      TIP=TIP*UNRM
      DO 100 J=2,J1
      JD=J-2
      DO 100 I=2,I1
      V2=U(I,J)**2+V(I,J)**2
      IF (IN(I,J).EQ.0.OR.V2.LT.0.01*V2MX) GO TO 100
C     IF (IN(I,J).EQ.0.) GO TO 100

      JLO=MAX(2,J-5)
      JHI=J
      ILO=MAX(2,I-5)
      IHI=MIN(I1,I+5)
      N=0
      DO 49 JJ=JLO,JHI
      DO 49 II=ILO,IHI
 49   N=N+NN(II,JJ)
      IF (N.GT.0) GO TO 100

c     JLO=MAX(2,J-2)
c     JHI=MIN(J1,J+2)
c     ILO=MAX(2,I-2)
c     IHI=MIN(I1,I+2)
c     VMAX=0.
c     DO 50 JJ=JLO,JHI
c     DO 50 II=ILO,IHI
c50   VMAX=MAX(VMAX,U(II,JJ)**2+V(II,JJ)**2)
c     IF (U(I,J)**2+V(I,J)**2.LT..9999*VMAX) GO TO 100
c     IF (U(I,J)**2+V(I,J)**2.NE.VMAX) GO TO 100
      NN(I,J)=1

      XS(I)=I-2
      YS(I)=JD
      XE(I)=XS(I)+UNRM*U(I,J)*ODX
      YE(I)=YS(I)+UNRM*V(I,J)*ODY
C TIP LENGTH SETMENT ALONG SHAFT (DX=TIP*U(I,J), DY=TIP*V(I,J))
      DXT=TIP*U(I,J)*ODX
      DYT=TIP*V(I,J)*ODY
      AX(I)=XE(I)-DXT
      AY(I)=YE(I)-DYT
C TIP WIDTH SEGMENT NORMAL TO SHAFT
      DXN=WD*DYT
      DYN=-WD*DXT
      BX(I)=AX(I)+DXN
      BY(I)=AY(I)+DYN
      CX(I)=AX(I)-DXN
      CY(I)=AY(I)-DYN
C DRAW SHAFT
      X2PT(1,I)=XS(I)+.5
      X2PT(2,I)=XE(I)+.5
      Y2PT(1,I)=YS(I)+.5
      Y2PT(2,I)=YE(I)+.5
      CALL GRAPH(X2PT(1,I),Y2PT(1,I))
      NCN(LINES)=0
C DRAW ARROWHEAD
      X2PT(1,I)=BX(I)+.5
      Y2PT(1,I)=BY(I)+.5
      CALL GRAPH(X2PT(1,I),Y2PT(1,I))
      NCN(LINES)=0
      X2PT(1,I)=CX(I)+.5
      Y2PT(1,I)=CY(I)+.5
      CALL GRAPH(X2PT(1,I),Y2PT(1,I))
      NCN(LINES)=0
 100  CONTINUE
      END
C ----------------------------------------------------------------------
      SUBROUTINE INPUT(NPLOT,FLD,FN,K,FNAME)
C ----------------------------------------------------------------------
      INCLUDE '../resolution.h'
      PARAMETER(L0=120000,I1=I0-1,I2=I0-2,I3=I0-3,
     1 J1=J0-1,J2=J0-2,J3=J0-3,K1=K0-1,K2=K0-2,K3=K0-3)
      CHARACTER FN*1,FNAME*30
      INTEGER*2 NFLD,NX1,NX2,NY1,NY2,NCN,IN1
      COMMON/FIXED/ODX,ODY,Z(K0+K1),ODZ(K1),ODZW(K0)
      DIMENSION NFLD(I0,J0),FLD(I0,*)
      COMMON/LINSAV/XLO,XHI,YLO,YHI,XCON,YCON,LINES,MAXCV,
     1 NX1(L0),NX2(L0),NY1(L0),NY2(L0),NCN(L0)
      COMMON/CON/TIME,FMIN,FMAX,IMN,JMN,IMX,JMX
      COMMON/DEPTH/IN1(I0,J0)

      READ(30,END=999) FN,FNAME,TIME,K,IMN,JMN,IMX,JMX,FMIN,FMAX,
     1 ((NFLD(I,J),I=2,I1),J=2,J1)
      WRITE(*,15) FN,TIME,FMIN,IMN,JMN,FMAX,IMX,JMX
 15   FORMAT(A1,' @ day',F9.1,'. mn= ',F7.2,' @ (',I3,',',I3,'), mx= ',
     1 F7.2,' @ (',I3,',',I3,')')

C FLD=FMIN+NFLD*(FMAX-FMIN)/9999.
      RF=(FMAX-FMIN)/9999.
      DO 105 J=2,J1
      DO 105 I=2,I1
      NFLD(I,J)=MAX(NFLD(I,J),0)
 105  FLD(I,J)=FMIN+RF*NFLD(I,J)
      IF (FN.NE.'D') RETURN
      DO 106 J=2,J1
      DO 106 I=2,I1
      IN1(I,J)=1
 106  IF (NFLD(I,J).LT.10) IN1(I,J)=0
      RETURN
 999  WRITE(4,1000) MAXCV,NPLOT
      WRITE(*,1000) MAXCV,NPLOT
 1000 FORMAT('N1= ',I6,' (LINES IN LONGEST CONVEC PLOT)'/
     1 'NP= ',I4,' (NUMBER OF PLOT FRAMES)')
      stop9
      END
C ----------------------------------------------------------------------
      SUBROUTINE GRAPH(X,Y)
C ----------------------------------------------------------------------
      PARAMETER(L0=120000)
      INTEGER*2 NX1,NX2,NY1,NY2,NCN
      COMMON/LINSAV/XLO,XHI,YLO,YHI,XCON,YCON,LINES,MAXCV,
     1 NX1(L0),NX2(L0),NY1(L0),NY2(L0),NCN(L0)
      DIMENSION X(*),Y(*)
C  INPUT:
C  X(1): BEGIN LINE X-COORDINATE
C  Y(1): BEGIN LINE Y-COORDINATE
C  X(1):   END LINE X-COORDINATE
C  Y(1):   END LINE Y-COORDINATE
      LINES=LINES+1
      IF (LINES.GT.L0) GO TO 100
      NX1(LINES)=(X(1)-XLO)*XCON
      NX2(LINES)=(X(2)-XLO)*XCON
      NY1(LINES)=(Y(1)-YLO)*YCON
      NY2(LINES)=(Y(2)-YLO)*YCON
C     NLO=MIN(NX1(LINES),NX2(LINES),NY1(LINES),NY2(LINES))
C     NHI=MAX(NX1(LINES),NX2(LINES),NY1(LINES),NY2(LINES))
C     IF (NLO.GE.0.AND.NHI.LE.9999) GO TO 90
C     WRITE(*,80) NX1(LINES),NX2(LINES),NY1(LINES),NY2(LINES),
C    1 X(1),X(2),Y(1),Y(2),XCON,YCON,XLO,YLO
C80   FORMAT(' NX1,NX2,NY1,NY2',4I6/'X1,X2,Y1,Y2,XCON,YCON,XLO,YLO',
C    1 8(1X,F7.1))
C     STOP
C90   CONTINUE
      RETURN
 100  WRITE(4,101) L0
      WRITE(*,101) L0
 101  FORMAT(' LINES.GT.L0(=',I6,').  INCREASE L0 PARAMETER TO ALLOW MOR
     1E LINES PER RECORD BEFORE RESTART.  STOP.')
      STOP1
      END
