      PROGRAM PLOTS
C THIS VERSION BRINGS NP PLOTS FROM HARD DISK TO CORE
C THEN PRODUCES INDIVIDUAL SCREEN PLOTS WITH POSTSCRIPT HARD COPY OPTIONS
C     PARAMETER(M0=974,N0=96564,N1=14020,NP=120)
      PARAMETER(M0=974,N0=42055,N1=11111,NP=364)

C NZRM
      PARAMETER(K0=3,LB0=100,K1=K0-1)
      INTEGER*2 NGL,NOL,NCV,NULL
      CHARACTER TITLE*77
      CHARACTER*30 NAME(NP)

C This must be consistent with plot0.f!
      CHARACTER*6 LBS(LB0,NP)

      CHARACTER*1 FN(NP)
      CHARACTER*1 TURN,JUNK
C NP= TOTAL NUMBER OF PLOT FRAMES TO BE STORED AND VIEWED
C M0= NUMBER OF LINES NEEDED FOR GRID TICK MARK LINES
C N0= NUMBER OF LINES NEEDED FOR OBSTACLE CROSS-HATCH AND STAIRCASE LINES
C N1= NUMBER OF LINES NEEDED FOR CONTOUR AND VECTOR PLOTS
C NGL IS GRID TICKS ARRAY
C NOL IS CROSS-HATCHED OBSTACLES LINES ARRAY
C NCV IS CONTOUR LINES ARRAY FOR ALL CONTOUR AND VECTOR PLOTS
C 
C RANGE OF LINES ARRAYS IS ASSUMED TO BE 0 TO 9999
      DIMENSION NGL(M0,4),NOL(N0,4,K1),LC(K1),NCV(N1,5,NP),NINT(NP),
     1 KZ(NP),LCV(NP),DEPTH(NP),TIME(NP),FMIN(NP),FMAX(NP),IMN(NP),
     2 JMN(NP),IMX(NP),JMX(NP)
      COMMON/FIXED/NW,LB
      COMMON/MAP/XMAP0,XMAP1,YMAP0,YMAP1,XSCALE,YSCALE,NPOST
C needed to avoid extranneous labels in land region
      COMMON/BLANK/NULL(N0)
      DATA TURN/'n'/

C PORTRAIT MODE
C 8 panels per page
C     DATA IPAN,NPAN,LAN/0,8,0/
C 4 panels per page
C      DATA IPAN,NPAN,LAN/0,4,0/
C 1 panel per page
       DATA IPAN,NPAN,LAN/0,1,0/

C LANDSCAPE MODE
C 4 panels per page
C     DATA IPAN,NPAN,LAN/0,4,1/
C 2 panels per page
C     DATA IPAN,NPAN,LAN/0,2,1/
C 1 panel per page
C      DATA IPAN,NPAN,LAN/0,1,1/

      OPEN(24,file='GRID',form='unformatted')
      OPEN(34,file='OBSTACLES',form='unformatted')
      OPEN(25,file='CONVEC',form='unformatted')
      REWIND 24
      REWIND 25
      REWIND 34
C POSTSCRIPT FILE
      OPEN(50,file='ps.dat')
      REWIND 50
      WRITE(50,50)
 50   FORMAT('%!')

      READ(24) LB,((NGL(N,L),L=1,4),N=1,LB)
      DO 52 K=1,K1
      READ(34) LK,((NOL(N,L,K),L=1,4),N=1,LK)
 52   LC(K)=LK
 53   CLOSE(24)
      CLOSE(34)
      LK=0
      DO 54 K=1,K1
 54   LK=MAX(LK,LC(K))
      IF (LB.LE.M0) GO TO 57
      WRITE(*,56) LB,M0
 56   FORMAT(I7,' GRID LINES READ INTO ',I7,'-LINE GL ARRAY. ARRAY IS UN
     1DER-DIMENSIONED. STOP')
      stop1
 57   IF (LK.LE.N0) GO TO 59
      WRITE(*,58) LK,N0
 58   FORMAT(I7,' OBST LINES READ INTO ',I7,'-LINE OL ARRAY. ARRAY IS UN
     1DER-DIMENSIONED. STOP')
      stop2
 59   DO 70 NF=1,NP
      READ(25,END=71) NINT(NF),(LBS(N,NF),N=1,NINT(NF))
      READ(25,END=71) KZ(NF),FN(NF),NAME(NF),
     1 DEPTH(NF),TIME(NF),FMIN(NF),FMAX(NF),IMN(NF),JMN(NF),IMX(NF),
     2 JMX(NF),NINTNF,LINES,((NCV(N,L,NF),L=1,5),N=1,LINES)
      N=TIME(NF)
      WRITE(*,61) N,FN(NF),FMIN(NF),FMAX(NF),NAME(NF)
 61   FORMAT('day',I4,A2,'. mn= ',1P,E9.2,', mx= ',E9.2,1X,A30)

      LCV(NF)=LINES
      IF (LINES.LE.N1) GO TO 70
      WRITE(*,62) LINES,N1
 62   FORMAT(I7,' LINES READ INTO ',I7,'-LINE NCV ARRAY.  NCV IS UNDER-
     1DIMENSIONED. STOP.')
      stop3
 70   CONTINUE
 71   CLOSE(25)
      NCOR=NF-1
C USER WINDOW COORDINATES ARE NORMALIZED INTEGERS SUCH THAT
C 0.LE.X.LE.9999 AND 0.LE.Y.LE.9999
      XMAP0=0.
      XMAP1=9999.
      YMAP0=0.
      YMAP1=9999.
C POST SCRIPT HARD COPY SCALING PARAMETERS
C LEAVE X AND Y UNITS AS POST SCRIPT DEFAULT, 1/72 INCH
C WITH STANDARD (90 DEGREE ROTATED) PAGE SIZE (11 X 8.5 INCHES)
      XSCALE=8.5*72./(YMAP1-YMAP0)
      YSCALE=11.*72./(XMAP1-XMAP0)
C SCREEN SCALING PARAMETERS    
      IF (LPOST.NE.0) WRITE(50,80)
 80   FORMAT('%!')
      DO 950 NF=1,NCOR
c     IF (FN(NF).NE.'v') GO TO 950
c     IF (FN(NF).NE.'v'.AND.FN(NF).NE.'T'.AND.FN(NF).NE.'s'.AND.FN(NF).
c    1NE.'D') GO TO 950
c     IF (FN(NF).NE.'S'.AND.FN(NF).NE.'w') GO TO 950
c     IF (FN(NF).NE.'v'.AND.FN(NF).NE.'D'.AND.FN(NF).NE.'0') GO TO 950
c     IF (TIME(NF).LT.23684.) GO TO 950

      K=KZ(NF)
      NPOST=1
      WRITE(50,91)
 91   FORMAT('newpath')

      N=MOD(IPAN,NPAN)+1
      IF (LAN.EQ.1) GO TO 112
      IF (NPAN.EQ.4) GO TO 104
      IF (NPAN.EQ.1) GO TO 109

C PORTRAIT MODE
C 8 panels per page
      IF (N.EQ.1) WRITE(50,101)
 101  FORMAT('20 100 translate 0.8 0.9 scale'/
     1 '/Times-Roman findfont'/
     2 '11 scalefont'/'setfont'/'0 setgray')
      IF (N.EQ.2) WRITE(50,102)
 102  FORMAT(/'630 0 translate 1.00 1.00 scale'/)
      IF (N.EQ.3) WRITE(50,103)
 103  FORMAT(/'-630 -800 translate 1.00 1.00 scale'/)
      IF (N.EQ.4) WRITE(50,102)
      IF (N.EQ.5) WRITE(50,103)
      IF (N.EQ.6) WRITE(50,102)
      IF (N.EQ.7) WRITE(50,103)
      IF (N.EQ.8) WRITE(50,102)
      GO TO 125

C 4 panels per page
 104  IF (N.EQ.1) WRITE(50,105)
 105  FORMAT('280 40 translate 0.62 0.33 scale'/
     1 '/Times-Roman findfont'/
     2 '12 scalefont'/'setfont'/'0 setgray')
      IF (N.EQ.2) WRITE(50,106)
 106  FORMAT(/'640 0 translate 1.00 1.00 scale'/)
      IF (N.EQ.3) WRITE(50,107)
 107  FORMAT(/'-640 -850 translate 1.00 1.00 scale'/)
      IF (N.EQ.4) WRITE(50,106)
      GO TO 125

C 1 panel per page
 109  WRITE(50,110)
 110  FORMAT('20 100 translate  0.9 0.8 scale'/
     1 '/Times-Roman findfont'/
     2 '18 scalefont'/'setfont'/'0 setgray')
      GO TO 125

C 2 panels per page

C LANDSCAPE MODE
 112  IF (NPAN.EQ.1) GO TO 119
      IF (NPAN.EQ.2) GO TO 116
C 4 panels per page
      IF (N.EQ.1) WRITE(50,113)
 113  FORMAT('290 25 translate 90 rotate 0.60 0.99 scale'/
     1 '/Times-Roman findfont'/
     2 '18 scalefont'/'setfont'/'0 setgray')
      IF (N.EQ.2) WRITE(50,114)
 114  FORMAT(/'630 0 translate 1.00 1.00 scale'/)
      IF (N.EQ.3) WRITE(50,115)
 115  FORMAT(/'-630 -840 translate 1.00 1.00 scale'/)
      IF (N.EQ.4) WRITE(50,114)
      GO TO 125

C 2 panels per page
 116  IF (N.EQ.1) WRITE(50,117)
 117  FORMAT('25 25 translate 90 rotate 0.60 0.99 scale'/
     1 '/Times-Roman findfont'/
     2 '17 scalefont'/'setfont'/'0 setgray')
      IF (N.EQ.2) WRITE(50,118)
 118  FORMAT(/'630 0 translate 1.00 1.00 scale'/)
      GO TO 125

 119  WRITE(50,120)
 120  FORMAT('576 46 translate 90 rotate 1.1 .55 scale'/
     1 '/Times-Roman findfont'/
     2 '17 scalefont'/'setfont'/'0 setgray')
      GO TO 125

 125  IF (NPOST.EQ.1.AND.MOD(IPAN,NPAN).EQ.0) WRITE(50,8888)
C8888 FORMAT('1280 setlinewidth 0.0 0.0 0.0 setrgbcolor'/
 8888 FORMAT('1800 setlinewidth 0.0 0.0 0.0 setrgbcolor'/
     1 ' -50  -50 moveto'/
     2 '1280  -50 lineto'/
     3 '1280 1100 lineto'/
     5 ' -50 1100 lineto'/
     6 'closepath'/
     7 'stroke')
      WRITE(50,126)
 126  FORMAT('1 setlinewidth 1.0 1.0 1.0 setrgbcolor')

      IF (TURN.NE.'y') CALL GRAF(LBS(1,NF),
     1 1,NULL,NGL(1,1),NGL(1,3),NGL(1,2),NGL(1,4),LB)
      IF (TURN.EQ.'y') CALL GRAF(LBS(1,NF),
     1 1,NULL,NGL(1,3),NGL(1,1),NGL(1,4),NGL(1,2),LB)

C brown land color fill for Postscript and screen plots
      C1=225./255.
      C2=150./255.
      C3=30./255.
      IF (NPOST.EQ.1) WRITE(50,127) C1,C2,C3
C127  FORMAT('2 setlinewidth ',3F7.4,' setrgbcolor')
 127  FORMAT(3F7.4,' setrgbcolor')

      IF (TURN.NE.'y') CALL GRAF(LBS(1,NF),
     1 1,NULL,NOL(1,1,K),NOL(1,3,K),NOL(1,2,K),NOL(1,4,K),LC(K))
      IF (TURN.EQ.'y') CALL GRAF(LBS(1,NF),
     1 1,NULL,NOL(1,3,K),NOL(1,1,K),NOL(1,4,K),NOL(1,2,K),LC(K))
      WRITE(50,128)
 128  FORMAT('2 setlinewidth')
      NDAY=TIME(NF)
      NDEPTH=DEPTH(NF)+0.5
      I=FMAX(NF)+0.5
      J=FMIN(NF)+0.5
      IF (FN(NF).NE.'v'.AND.FN(NF).NE.'w')
     1 WRITE(TITLE,132) NAME(NF),NDAY,NDEPTH,FMIN(NF),FMAX(NF)
      IF (FN(NF).EQ.'v')
     1 WRITE(TITLE,133) NAME(NF),NDAY,NDEPTH,J,I
      IF (FN(NF).EQ.'w')
     1 WRITE(TITLE,134) NAME(NF),NDAY,NDEPTH,INT(FMIN(NF)),INT(FMAX(NF))
 132  FORMAT(A30,' @ day',I4,'. z=',I4,'m. mn=',F6.1,', mx=',F5.1)
 133  FORMAT(A30,' @ day',I4,'. z=',I4,'m. Hmx-Hmn=',I3,'cm, Vmx=',I3,
     1 'cm/s')
 134  FORMAT(A30,' @ day',I4,'. z=',I4,'m. mn=',I6,', mx=',I5)

C LOCATION OF FIRST POSTSCRIPT CHARACTER
      NXPOST=1*XSCALE
      NYPOST=100*YSCALE
C white title
      WRITE(50,136)
 136  FORMAT('1.0 1.0 1.0 setrgbcolor')
      WRITE(50,137) NXPOST,NYPOST,TITLE
 137  FORMAT(/2I5,' moveto'/'(',A77,')',' show')

 945  IF (TURN.NE.'y') CALL GRAF(LBS(1,NF),NOCOL,NCV(1,5,NF),
     1NCV(1,1,NF),NCV(1,3,NF),NCV(1,2,NF),NCV(1,4,NF),LCV(NF))
      IF (TURN.EQ.'y') CALL GRAF(LBS(1,NF),NOCOL,NCV(1,5,NF),
     1NCV(1,3,NF),NCV(1,1,NF),NCV(1,4,NF),NCV(1,2,NF),LCV(NF))
      IPAN=IPAN+1
      IF (MOD(IPAN,NPAN).EQ.0) WRITE(50,947)
 947  FORMAT('showpage')
 950  CALL FLUSH(50)
      END
C ----------------------------------------------------------------------
      SUBROUTINE GRAF(LBS,NOCOL,NCN,NX1,NY1,NX2,NY2,LINES)
C ----------------------------------------------------------------------
      INTEGER*2 NCN,NX1,NX2,NY1,NY2
      CHARACTER*6 LBS(*)
      DIMENSION NCN(*),NX1(*),NX2(*),NY1(*),NY2(*),P(2),T(2)
      COMMON/RASTERS/IRAST0,IRAST1,JRAST0,JRAST1
      COMMON/MAP/XMAP0,XMAP1,YMAP0,YMAP1,XSCALE,YSCALE,NPOST

C NOCOL=1 means no color change in GRAF !

C MAXIMUM OF 17 CONTOUR COLORS AND CONTOUR LABEL CHARACTERS
C     DIMENSION NC1(18),NC2(18),NC3(18),MC1(18),MC2(18),MC3(18)
C 10 intervals
      DIMENSION NC1(10),NC2(10),NC3(10),MC1(10),MC2(10),MC3(10)
C screen colors
C white,brown,purple,blue,gray,green,yellow,orange,red,white
C Screen plot colors
C white vectors (NC=1), black background
C     DATA NC1/255,150,  0,255,128,  0,255,255,255,255/
C     DATA NC2/255,100,  0,  0,128,255,255,128,  0,255/
C     DATA NC3/255, 20,255,255,128,  0,  0,  0,  0,255/
      DATA NC1/200,150,255,  0,150,  0,255,255,255,255/
      DATA NC2/200,100,  0,  0,150,255,255,128,  0,255/
      DATA NC3/200, 20,255,255,255,  0,  0,  0,  0,255/
C Clear background Postscript plot colors
c gray vectors (NC=1), clear background, darken yellow contour
      DATA MC1/50,150,  0,255,128,  0,200,255,255,255/
      DATA MC2/50,100,  0,  0,128,255,200,128,  0,255/
      DATA MC3/50, 20,255,255,128,  0,  0,  0,  0,255/

C 18 intervals
C     DATA NC1/128,150, 75,  0,128,255,185,128, 64,  0,128,255,255,255,
C    1 255,255,255,255/
C     DATA NC2/128,100, 50 , 0,  0,  0, 64,128,185,255,255,255,185,128,
C    1 64,   0,128,255/
C     DATA NC3/128, 20,128,255,255,255,185,128,185,  0,  0,  0,  0,  0,
C    1  0,   0,128,255/
C  INPUT:
C  X1  BEGINNING X-COORDINATES OF LINES
C  X2  ENDING X-COORDINATES OF LINES
C  Y1  BEGINNING Y-COORDINATES OF LINES
C  Y2  ENDING Y-COORDINATES OF LINES
C  LINES  NUMBER OF LINES TO BE DRAWN
C    ICOLOR   AN INTEGRER FOR SETTING THE COLOR OF THE CURVE

C  DRAW THE LINES
      DO 10 N=1,LINES
      NC=ABS(NCN(N))
      NCC=NC
C 9 intervals
      NC=MOD(NC,9)+1
C 17 intervals
C     NC=MOD(NC,17)+1

Color Postscript command
      IF (NOCOL.EQ.1) GO TO 2
clear background
c     C1=MC1(NC)/255.
c     C2=MC2(NC)/255.
c     C3=MC3(NC)/255.
c black background
      C1=NC1(NC)/255.
      C2=NC2(NC)/255.
      C3=NC3(NC)/255.
      WRITE(50,1) C1,C2,C3
 1    FORMAT(3F7.4,' setrgbcolor')

 2    IF (NCN(N).LT.0) GO TO 5
      P(1)=NX1(N)
      P(2)=NY1(N)
      T(1)=NX2(N)
      T(2)=NY2(N)
      NXPOST1=XSCALE*NX1(N)
      NXPOST2=XSCALE*NX2(N)
      NYPOST1=YSCALE*NY1(N)
      NYPOST2=YSCALE*NY2(N)

      WRITE(50,3) NXPOST1,NYPOST1,NXPOST2,NYPOST2
 3    FORMAT(2I5,' moveto'/2I5,' lineto'/'stroke')
      GO TO 10

C SW CORNER OF CHARACTER IS AT NXC,NYC
 5    NXC=(NX1(N)+NX2(N))/2
      NYC=(NY1(N)+NY2(N))/2
C SW CORNER OF CHARACTER IS AT SW CELL CORNER
C     NXC=NX1(N)
C     NYC=NY1(N)
      NXPOST=NXC*XSCALE
      NYPOST=NYC*YSCALE
      WRITE(50,7) NXPOST,NYPOST,LBS(NCC)
 7    FORMAT(2I5,' moveto'/'(',A6,')',' show')
 10   CONTINUE
      END
