C *******************PROGRAM DIECAST************************************
C DIECAST Ocean Model                                         June, 2004
C 2-d island wake problem
C note:
C some arrays are (or may be made) redundant, and vertical dimension is
C also redundant, so much storage may be CAREFULLY eliminated
C **********************************************************************

C MAIN PROGRAM
Controls calculation, diagnostics, saves graphics postprocessing data

C *** RESOLUTION PARAMETERS ***
      INCLUDE 'resolution.h'
C NB0 is dimension parameter for SEVP elliptic solver
C (see Roache, Elliptic Marching Methods and Domain Decomposition, CRC)

C derived resolution parameters
      PARAMETER(IJ0=I0+J0,IJ1=IJ0-1,I1=I0-1,I2=I0-2,J1=J0-1,J2=J0-2,
     1 K1=K0-1,K2=K0-2,NB1=NB0-1)
C horizontal resolution parameters: I0,I1,I2,I3, J0,J1,J2,J3
C vertical resolution parameters: K0,K1,K2

C double precision SEVP inverse and influence coefficient arrays
      REAL*8 RINV,RINV1,DUM0,DUM1,DUM2,X,H
C low precision logical-grid depth (KB) and masking arrays
      INTEGER*2 KB,IU0,IV0,IN,IU,IV,IW

C mean flow arrays
      COMMON U1(I0,J0,K1),U2(I0,J0,K1),V1(I0,J0,K1),V2(I0,J0,K1),
     1 P(I0,J0,K1),ULF(I0,J0,K1),VLF(I0,J0,K1),DMX(I1,J0,K1),
     2 DMY(I0,J1,K1)
      COMMON/ADV/U(I1,J0,K1),V(I0,J1,K1),PX(I0,J0),PY(I0,J0)
C user-defined scalar control parameters
      COMMON/LPI/M2,M6,MVI,IE(NB0)
      COMMON/CONTRO/DT,TLZ,DM0,DE0,DMZ0,FLTW,AV,
     1 DAODT,ITFDAY,LRSTRT,MXIT,MOVI
      COMMON/SCRTCH/SCR(I0,J0,K0+2),SCLN(IJ0,2),XI2(I0,J0,2)
C derived scalars
      COMMON/SCA/DX,DY,ODX,ODY,ODT,GB,PRN,DAYS,OFLTW,ITF
C data for direct SEVP elliptic solver
      COMMON/SEVP/RINV(I2,I2,NB0),RINV1(I2,I2,NB1),DUM0(I2,NB1),
     1 DUM1(I2),DUM2(I2),X(I0,J0),H(I0,J0),AL(I2,J2),AB(I2,J2),
     2 AC(I2,J2),AR(I2,J2),AT(I2,J2),S(I2,J2)
C vertical grid (redundant)
      COMMON/ZFS/Z(K0+K1),ODZ(K1),ODZW(K0)
C logical bathymetric arrays
      COMMON/BATHY/KB(I0,J0),IU0(I0,J0),IV0(I0,J0),
     1 IN(I0,J0,K1),IU(I1,J0,K1),IV(I0,J1,K1),IW(I0,J0,K0)

 1    FORMAT('ITF=',I6,' (',F7.2,' days), VLO=',F6.1,
     1 ' at (',I3,',',I3,'), VHI=',F6.1,' at (',I3,',',I3,')')

C -----------------
C OUTPUT DATA FILES
C -----------------
C RUN HISTORY DATA
      OPEN(14,file='TR')
C RESTART DATA
      OPEN(19,file='SV',form='unformatted')
      REWIND 19

C PLOT DATA FILES ARE WRITTEN TO SUBDIRECTORIES
C XY PLOTS: XYPLOTS/DATA (LOGICAL UNIT 30)
C PLOT DATA FILES
      OPEN(30,file='XYPLOTS/DATA',form='unformatted')
C STOP-RUN FILE
      OPEN(42,file='STOPRUN')
      REWIND 14
      REWIND 30
      REWIND 42
      LSTOP=0
      WRITE(42,416) LSTOP

C --------------------------------------------------
C INITIALIZE DERIVED SCALARS AND ALL NON-ZERO FIELDS
C --------------------------------------------------
      CALL INITFS
      write(14,698) ((in(i,j,1),i=2,i1),j=J1,2,-1)
 698  format(80i1)
      ITFDAY=DAODT

      IF (LMOVI.NE.1) GO TO 89
C ---------------------------------
C OPTIONAL COMPUTER-GENERATED MOVIE
C ---------------------------------
C XY ANIMATION: MOVIE/MV0 AND MOVIE/DATA (LOGICAL UNITS 21 AND 23)
      OPEN(21,file='MOVIE/DATA',form='unformatted')
      OPEN(23,file='MOVIE/MV0')
      REWIND 21
      REWIND 23
C TIME MARCHES HDT PER TIME STEP
      TMP=MVI*DT
      WRITE(23,87) I0,J0,K0,DX,DY,TMP,F
 87   FORMAT(3I3,3E11.4/(1X,7E11.4))
      WRITE(23,88) (Z(2*K),K=1,2),(((IN(I,J,K),I=1,I0),J=1,J0),K=1,2)
 88   FORMAT(2E11.4/(80I1))
      CLOSE(23)
C Needed for change of time step on restart
 89   ITF=DAYS*DAODT
      MNIT=ITF

C MAIN TIME INTEGRATION LOOP 100
 100  ITF=ITF+1
      DAYS=ITF/DAODT

C ---------------------
      CALL FS
C ---------------------

C MONITOR SOLUTION PROGRESS IN DETAIL AND CHECK FOR POSSIBLE INSTABILITY
C (THIS HAPPENS ONLY WHEN DT IS TOO LARGE OR I.C.S OR B.C.S ARE UNPHYSICAL)
      CALL RANGE(V2,SCLN,SCLN(1,2),IN,I0,2,2,I1,J1,ILO,JLO,IHI,JHI,VLO,
     1 VHI)
      IF (ITF-MNIT.GT.100.AND.MOD(ITF,M2).NE.0) GO TO 103
      TMP=0.
      DO 101 J=2,J2
      DO 101 I=2,I2
 101  TMP=MAX(TMP,(1.-IU0(I,J))*ABS(U(I,J,1)),
     1 (1.-IV0(I,J))*ABS(V(I,J,1)))
      WRITE(*,102) ITF,ILO,JLO,VLO,IHI,JHI,VHI,TMP
      WRITE(14,102) ITF,ILO,JLO,VLO,IHI,JHI,VHI,TMP
 102  FORMAT('at itf=',I6/'(ILO,JLO,VLO,IHI,JHI,VHI)=(',2I4,1X,E13.6,
     1 2I4,1X,E13.6,')'/14X,'MAX ABS VEL ON LAND=',F8.4)
 103  IF ((VHI-VLO).LT.600.) GO TO 130
      WRITE(14,102) ITF,ILO,JLO,VLO,IHI,JHI,VHI,TMP
      CALL FSPLTS(MXIT,0)
      WRITE(14,104) ITF
 104  FORMAT('stop at itf=',i6,' due to unixpectedly large velocity.')
      stop0
 130  IF (ITF.NE.MXIT) GO TO 300
      CALL SETR(SCR,I0*J0,0.)
      DO 200 K=1,K1
      SVR=DX/ODZ(K)*1.E-12
      DO 200 J=1,J2
      DO 200 I=2,I1
 200  SCR(I,J,1)=SCR(I,J,1)+V(I,J,K)*SVR
      DO 202 I=3,I1
      DO 201 J=1,J2
 201  SCR(I,J,5)=SCR(I-1,J,1)
      DO 202 J=1,J2
 202  SCR(I,J,1)=SCR(I,J,1)+SCR(I,J,5)

C ----------------------
COMPUTER-GENERAGED MOVIE
C ----------------------

      IF (MOD(ITF,MVI).NE.0.OR.LMOVI.NE.1) GO TO 205
C SAVE TOP LEVEL P AND VEL
      CALL COMXY(P,DAYS,I0)
      CALL COMXY(U2,DAYS,IN,I0)
      CALL COMXY(V2,DAYS,IN,I0)

 205  IF (MOD(ITF,M6).NE.0.AND.ITF.NE.MXIT) GO TO 232
      DO 212 J=1,J2
      DO 212 I=1,I2
 212  SCR(I+1,J+1,2)=
     1 .25*(SCR(I,J,1)+SCR(I+1,J,1)+SCR(I,J+1,1)+SCR(I+1,J+1,1))
      DO 214 J=J1,J0
      DO 214 I=1,I2
 214  SCR(I+1,J,2)=SCR(I,J2,2)
      CALL XYPLOT('x','streamfunction (Sverdrups)    ',SCR(1,1,2),1,1)

 232  AV=AV+1.
      WT=1./AV
      OWT=1.-WT
      DO 240 J=1,J2
      DO 240 I=1,I2
C MEAN SURFACE PRESSURE
      XI2(I+1,J+1,2)=OWT*XI2(I+1,J+1,2)+WT*P(I+1,J+1,1)
C MEAN SQUARED DEVIATION OF SURFACE PRESSURE FROM MEAN
 240  XI2(I+1,J+1,1)=OWT*XI2(I+1,J+1,1)
     1 +WT*(P(I+1,J+1,1)-XI2(I+1,J+1,2))**2
      IF (ITF.NE.MXIT) GO TO 300
      CALL XYPLOT('u','longitudinal velocity (cm/sec)',U2,1,1)
      CALL XYPLOT('v','latitudinal velocity (cm/sec) ',V2,1,1)
 300  IF (MOD(ITF,ITFDAY).NE.0) GO TO 402

CONTOUR AND VECTOR PLOTS
      CALL FSPLTS(MXIT,0)
      CALL FLUSH(30)
 402  IF (MOD(ITF,M2).NE.0.AND.ITF.NE.MXIT) GO TO 410
C RESTART DATA
 403  REWIND 19
      WRITE(19) ITF,DAYS,AV,(X(I,2),I=2,I1),U1,U2,V1,V2,ULF,VLF,U,V,XI2
      WRITE(14,404) ITF
      WRITE(*,404) ITF
 404  FORMAT('restart file written at ITF= ',I6)
 410  IF (MOD(ITF,10).NE.0) GO TO 420
      IF (LSTOP.NE.0) STOP
      REWIND 42
      READ(42,416) LSTOP
 416  FORMAT(I1)
 420  IF (LSTOP.NE.0) GO TO 403
      IF (ITF.LT.MXIT) GO TO 100
      END
C *********************
C MAIN DYNAMICS PROGRAM
C *********************
      SUBROUTINE FS
C EXACT CONSERVATION IS SATISFIED.
      REAL*8 RINV,RINV1,DUM0,DUM1,DUM2,X,H
      INCLUDE 'resolution.h'
      PARAMETER(IJ0=I0+J0,IJ1=IJ0-1,I1=I0-1,I2=I0-2,I3=I0-3,J1=J0-1,
     1 J2=J0-2,J3=J0-3,K1=K0-1,K2=K0-2,NB1=NB0-1)
      INTEGER*2 KB,IU0,IV0,IN,IU,IV,IW
      COMMON U1(I0,J0,K1),U2(I0,J0,K1),V1(I0,J0,K1),V2(I0,J0,K1),
     1 P(I0,J0,K1),ULF(I0,J0,K1),VLF(I0,J0,K1),DMX(I1,J0,K1),
     2 DMY(I0,J1,K1)
      COMMON/ADV/U(I1,J0,K1),V(I0,J1,K1),PX(I0,J0),PY(I0,J0)
      COMMON/CONTRO/DT,TLZ,DM0,DE0,DMZ0,FLTW,AV,
     1 DAODT,ITFDAY,LRSTRT,MXIT,MOVI
      COMMON/FLX/
     1 UX(I1,J2),UY(I2,J1),UZ(I2,J2,2),VX(I1,J2),VY(I2,J1),VZ(I2,J2,2),
     2 TX(I1,J2),TY(I2,J1),TZ(I2,J2,2)
      COMMON/SCRTCH/SCR(I0,J0,K0+2),SCLN(IJ0,2),XI2(I0,J0,2)
      COMMON/SCA/DX,DY,ODX,ODY,ODT,GB,PRN,DAYS,OFLTW,ITF
      COMMON/SEVP/RINV(I2,I2,NB0),RINV1(I2,I2,NB1),DUM0(I2,NB1),
     1 DUM1(I2),DUM2(I2),X(I0,J0),H(I0,J0),AL(I2,J2),AB(I2,J2),
     2 AC(I2,J2),AR(I2,J2),AT(I2,J2),S(I2,J2)
      COMMON/BATHY/KB(I0,J0),IU0(I0,J0),IV0(I0,J0),
     1 IN(I0,J0,K1),IU(I1,J0,K1),IV(I0,J1,K1),IW(I0,J0,K0)
C Z IS DISTANCE FROM TOP OCEAN BOUNDARY, INCREASING WITH INCREASING K
      COMMON/ZFS/Z(K0+K1),ODZ(K1),ODZW(K0)
      COMMON/LPI/M2,M6,MVI,IE(NB0)

C two-dimensional problem: one layer only
      K=1
C 4th order accurate pressure gradient, old way
      DO 300 J=2,J1
      DO 290 I=2,I2
 290  UX(I,J-1)=IU(I,J,K)*(P(I+1,J,K)-P(I,J,K))
      UX(1,J-1)=UX(2,J-1)
 300  UX(I1,J-1)=UX(I2,J-1)
      DO 302 J=2,J2
      DO 302 I=2,I1
 302  VY(I-1,J)=IV(I,J,K)*(P(I,J+1,K)-P(I,J,K))
      DO 303 I=2,I1
      VY(I-1,1)=VY(I-1,2)
 303  VY(I-1,J1)=VY(I-1,J2)
      TMP=1./12.
      DO 304 J=2,J1
      DO 304 I=3,I2
 304  PX(I,J)=(7.*(UX(I,J-1)+UX(I-1,J-1))-UX(I+1,J-1)-UX(I-2,J-1))*TMP
      DO 305 J=2,J1
      PX(2,J)=PX(3,J)
 305  PX(I1,J)=PX(I2,J)
      DO 306 J=3,J2
      DO 306 I=2,I1
 306  PY(I,J)=(7.*(VY(I-1,J)+VY(I-1,J-1))-VY(I-1,J+1)-VY(I-1,J-2))*TMP
      DO 307 I=2,I1
      PY(I,2)=PY(I,3)
 307  PY(I,J1)=PY(I,J2)

C HORIZONTAL FLUXES
 359  DO 360 J=2,J1
      DO 360 I=1,I1
      TMP=.5*U(I,J,K)

C free-slip
C     UX(I,J-1)=(TMP*(U2(I,J,K)+U2(I+1,J,K))
C    1 -DM0*(U1(I+1,J,K)-U1(I,J,K)))*IU(I,J,K)
C     VX(I,J-1)=(TMP*(V2(I,J,K)+V2(I+1,J,K))
C    1 -DM0*(V1(I+1,J,K)-V1(I,J,K)))*IU(I,J,K)
C
C non-slip
      UX(I,J-1)=TMP*(U2(I,J,K)+U2(I+1,J,K))*IU(I,J,K)
     1 -DM0*(U1(I+1,J,K)-U1(I,J,K))
 360  VX(I,J-1)=TMP*(V2(I,J,K)+V2(I+1,J,K))*IU(I,J,K)
     1 -DM0*(V1(I+1,J,K)-V1(I,J,K))
      DO 361 J=1,J1
      DO 361 I=2,I1
      TMP=.5*V(I,J,K)

C free-slip
C     UY(I-1,J)=(TMP*(U2(I,J,K)+U2(I,J+1,K))
C    1 -DM0*(U1(I,J+1,K)-U1(I,J,K)))*IV(I,J,K)
C     VY(I-1,J)=(TMP*(V2(I,J,K)+V2(I,J+1,K))
C    1 -DM0*(V1(I,J+1,K)-V1(I,J,K)))*IV(I,J,K)

C non-slip
      UY(I-1,J)=TMP*(U2(I,J,K)+U2(I,J+1,K))*IV(I,J,K)
     1 -DM0*(U1(I,J+1,K)-U1(I,J,K))
 361  VY(I-1,J)=TMP*(V2(I,J,K)+V2(I,J+1,K))*IV(I,J,K)
     1 -DM0*(V1(I,J+1,K)-V1(I,J,K))

C free-slip sides only
      DO 362 J=2,J1
      VX(1,J-1)=0.
 362  VX(I1,J-1)=0.

      DO 440 J=2,J1
      DO 440 I=2,I1
      U2(I,J,K)=U1(I,J,K)-DT*((UX(I,J-1)-UX(I-1,J-1)+PX(I,J))*ODX
     1 +(UY(I-1,J)-UY(I-1,J-1))*ODY)
     2 *IN(I,J,K)
 440  V2(I,J,K)=V1(I,J,K)-DT*((VX(I,J-1)-VX(I-1,J-1))*ODX
     1 +(VY(I-1,J)-VY(I-1,J-1)+PY(I,J))*ODY)
     2 *IN(I,J,K)

C ------------------------
C OPEN BOUNDARY CONDITIONS
C ------------------------
C use most recent outflow velocity, V(I,J1,K), which is never negative
C UPWIND METHOD based on NBV.
      DTDY=DT*ODY
      DO 508 I=2,I1
      TMP=IN(I,J1,K)*DTDY*V(I,J1,K)
      U2(I,J1,K)=U2(I,J1,K)-TMP*ULF(I,J1,K)
      V2(I,J1,K)=V2(I,J1,K)-TMP*VLF(I,J1,K)
      TMP=IN(I,2,K)*DTDY*V(I,1,K)
 508  V2(I,2,K)=V2(I,2,K)+TMP*VLF(I,1,K)
      DO 630 I=2,I1
C No negative constraint
C     V2(I,J1,K)=MAX(0.,V2(I,J1,K))
C Neuman
      U2(I,J0,K)=U2(I,J1,K)
 630  V2(I,J0,K)=V2(I,J1,K)

C 4TH-ORDER INTERPOLATES TO CONTRAVARIANT (STAGGERED) LOCATIONS
C LATER TRY INTERPOLATING DIFFERENCES ONLY
      TMP=1./16.
      DO 632 J=2,J1
C     DO 632 I=3,I3
      DO 632 I=2,I2
 632  U(I,J,K)=U(I,J,K)+IU(I,J,K)*((9.*(U2(I,J,K)+U2(I+1,J,K))
     1 -U2(I-1,J,K)-U2(I+2,J,K))*TMP-U(I,J,K))
C     DO 634 J=2,J1
C 2ND-ORDER SIDEWALLS
C     U(2,J,K)=IU(2,J,K)*.5*(U2(2,J,K)+U2(3,J,K))
C634  U(I2,J,K)=IU(I2,J,K)*.5*(U2(I2,J,K)+U2(I1,J,K))
      DO 636 J=2,J2
      DO 636 I=2,I1
 636  V(I,J,K)=V(I,J,K)+IV(I,J,K)*((9.*(V2(I,J,K)+V2(I,J+1,K))
     1 -V2(I,J-1,K)-V2(I,J+2,K))*TMP-V(I,J,K))
      DO 638 I=2,I1
C 2ND-ORDER INFLOW
C     V(I,2,K)=IV(I,2,K)*.5*(V2(I,2,K)+V2(I,3,K))
C 2ND-ORDER OUTFLOW
C     V(I,J2,K)=IV(I,J2,K)*.5*(V2(I,J2,K)+V2(I,J1,K))
 638  V(I,J1,K)=V2(I,J1,K)
 640  CONTINUE

C ------------------------------
C Subtract mean boundary outflow as required by incompressibility
C ------------------------------
C calculate net flow EXITing region
      TEMP=1./I2
      TMP1=0.
      TMP2=0.
      DO 641 I=2,I1
      TMP1=TMP1+V(I,J1,K)
 641  TMP2=TMP2+V(I,1,K)
C adjust outflow
      TMP=(TMP2-TMP1)*TEMP
      DO 642 I=2,I1
      V(I,J1,K)=V(I,J1,K)+TMP
 642  V(I,J2,K)=V(I,J1,K)

      MXMASK=8
      ITMASK=0
 650  ITMASK=ITMASK+1
C ZERO OUT ADVECTION VEL OVER LAND
      TMP=0.
      DO 652 J=2,J1
      DO 652 I=2,I2
      TMP=MAX(TMP,(1.-IU0(I,J))*U(I,J,1))
 652  U(I,J,1)=IU0(I,J)*U(I,J,1)
      DO 654 J=2,J2
      DO 654 I=2,I1
      TMP=MAX(TMP,(1.-IV0(I,J))*V(I,J,1))
 654  V(I,J,1)=IV0(I,J)*V(I,J,1)
      I=ITMASK-1
      IF (ITF.LT.10.OR.MOD(ITF,100).EQ.0) WRITE(*,655) I,TMP
      IF (ITF.LT.10.OR.MOD(ITF,100).EQ.0) WRITE(14,655) I,TMP
 655  FORMAT
     1 (9X,'solver iteration #',I2,', max vel on land =',F9.5,' cm/sec')
C ----------------------------------
C use solver to eliminate divergence
C ----------------------------------
      TMP1=ODX/ODZ(1)
      TMP2=ODY/ODZ(1)
      DO 663 J=2,J1
      DO 663 I=2,I1
 663  S(I-1,J-1)=((U(I,J,1)-U(I-1,J,1))*TMP1+(V(I,J,1)-V(I,J-1,1))*TMP2)

C FOR RIGID TOP DO SOLVER AND CORRECT U, V, W AND ADJUST P.
      CALL REP(AL,AB,AC,AR,AT,RINV,RINV1,DUM0,DUM1,DUM2,S,H,X,IE,I0,I2,
     1 NB0)
      DO 664 J=2,J1
      DO 664 I=2,I1
 664  P(I,J,1)=P(I,J,1)+ODT*X(I,J)

Changed pressure gradient DMX,DMY (scratch arrays here)
      DO 668 J=2,J1
      DO 668 I=2,I2
 668  DMX(I,J,1)=(X(I+1,J)-X(I,J))*ODX
      DO 669 J=2,J2
      DO 669 I=2,I1
 669  DMY(I,J,1)=(X(I,J+1)-X(I,J))*ODY
C TOP LAYER
      DO 670 J=2,J1
      DO 670 I=2,I2
 670  U(I,J,1)=U(I,J,1)-DMX(I,J,1)
      DO 671 J=2,J2
      DO 671 I=2,I1
 671  V(I,J,1)=V(I,J,1)-DMY(I,J,1)

      if (itf.eq.1.and.itmask.lt.9) go to 650
      IF (TMP.GT..01.AND.ITMASK.LT.MXMASK) GO TO 650

C 4TH ORDER INTERPOLATE U AND V TO U2 AND V2 HERE
C LATER INTERPOLATE CHANGES DUE TO DP
      TMP=1./16.
      DO 686 J=2,J1
      DO 686 I=3,I2
 686  U2(I,J,K)=(9.*(U(I,J,K)+U(I-1,J,K))-U(I+1,J,K)-U(I-2,J,K))*TMP
     1 *IN(I,J,K)
      DO 687 J=2,J1
C 2ND-ORDER SIDEWALL BOUNDARIES
      U2(2,J,K)=.5*U(2,J,K)*IN(2,J,K)
 687  U2(I1,J,K)=.5*U(I2,J,K)*IN(I1,J,K)
      DO 688 J=3,J2
      DO 688 I=2,I1
 688  V2(I,J,K)=(9.*(V(I,J,K)+V(I,J-1,K))-V(I,J+1,K)-V(I,J-2,K))*TMP
     1 *IN(I,J,K)
      DO 689 I=2,I1
C 2ND-ORDER INFLOW
      V2(I,2,K)=IN(I,2,K)*.5*(V(I,2,K)+V(I,1,K))
C 2ND-ORDER OUTFLOW
 689  V2(I,J1,K)=V(I,J2,K)*IN(I,J1,K)

      IF (ITF.GT.20.AND.MOD(ITF,M2).NE.0) GO TO 702
check incompressibility
      TMP=0.
      ERR=0.
c     ermax=0.
      DO 700 J=2,J1
      DO 700 I=2,I1
      TMP1=(U(I,J,1)-U(I-1,J,1))*ODX
      TMP2=(V(I,J,1)-V(I,J-1,1))*ODY
      if (mod(itf,1080).ne.0.or.itf.ne.mxit.or.i.lt.6.or.j.lt.6)
     1 go to 699
      temp=ermax
      ermax=max(ermax,in(i,j,1)*abs(tmp1+tmp2))
      if (ermax.eq.temp) go to 699
      write(*,695) itf,i,j,tmp1,tmp2
 695  format('dudx,dvdy at itf,i,j,k=',3i5,':',1p,2(1x,e12.5))
      write(*,696) U(I,J,1),U(I-1,J,1),V(I,J,1),V(I,J-1,1)
 696  format(4f7.2)
      write(*,697) iu0(i,j),iu0(i-1,j),iv0(i,j),iv0(i,j-1)
 697  format(4i7)
 699  continue

      TMP=TMP+IN(I,J,K)*(ABS(TMP1)+ABS(TMP2))
 700  ERR=ERR+IN(I,J,K)*ABS(TMP1+TMP2)
      ERR=ERR/TMP
      WRITE(*,701) ITF,ERR
      WRITE(14,701) ITF,ERR
 701  FORMAT('at itf=',I5,
     1 ': normalized mean incompressibility error= ',1PE8.1)

      write(14,1101) (v2(i,j0/4,1),i=2,i1)
      write(14,1101) (v(i,j0/4,1),i=2,i1)
 1101 format('cross-island longitudinal profiles of v2,v'/(20f4.0))
      write(14,1111) (v2(i0/2,j,1),j=2,j1)
      write(14,1111) (v(i0/2,j,1),j=2,j1)
 1111 format('mid-longitude profiles of v2,v'/(20f4.0))

C UPDATE USING FLTW METHOD
C non-divergent 2-d advection velocity becomes time centered
 702  DO 710 J=2,J0
      DO 710 I=2,I1
      U1(I,J,K)=OFLTW*ULF(I,J,K)+FLTW*(U1(I,J,K)+U2(I,J,K))
      ULF(I,J,K)=U2(I,J,K)
      V1(I,J,K)=OFLTW*VLF(I,J,K)+FLTW*(V1(I,J,K)+V2(I,J,K))
 710  VLF(I,J,K)=V2(I,J,K)
      PSM=0.
      DO 724 J=2,J1
      DO 724 I=2,I1
C P(I,J,1)+X(I,J)=SURFACE PRESSURE THIS STEP, IS USED TO START NEXT STEP
C P(I,J,1)+2.*X(I,J) MIGHT BE A BETTER STARTER FOR NEXT TIME STEP
      P(I,J,1)=P(I,J,1)+ODT*X(I,J)
 724  PSM=PSM+P(I,J,1)
      PSM=PSM/(I2*J2)
      DO 725 J=2,J1
      DO 725 I=2,I1
      P(I,J,1)=P(I,J,1)-PSM
 725  P(I,J,2)=P(I,J,1)
      END
C ******************
C GRAPHICS PACKAGE *
C ******************
C ----------------------------------------------------------------------
      SUBROUTINE FSPLTS(MXIT,NFLG)
C SAVES PLOT DATA
C ----------------------------------------------------------------------
C HORIZONTAL CONTOUR PLOTS
      INCLUDE 'resolution.h'
      PARAMETER(IJ0=I0+J0,IJ1=IJ0-1,I1=I0-1,I2=I0-2,J1=J0-1,J2=J0-2,
     1 K1=K0-1,K2=K0-2)
      INTEGER*2 KB,IU0,IV0,IN,IU,IV,IW
      COMMON U1(I0,J0,K1),U2(I0,J0,K1),V1(I0,J0,K1),V2(I0,J0,K1),
     1 P(I0,J0,K1),ULF(I0,J0,K1),VLF(I0,J0,K1),DMX(I1,J0,K1),
     2 DMY(I0,J1,K1)
      COMMON/ADV/U(I1,J0,K1),V(I0,J1,K1),PX(I0,J0),PY(I0,J0)
      COMMON/SCRTCH/SCR(I0,J0,K0+2),SCLN(IJ0,2),XI2(I0,J0,2)
      COMMON/SCA/DX,DY,ODX,ODY,ODT,GB,PRN,DAYS,OFLTW,ITF
      COMMON/BATHY/KB(I0,J0),IU0(I0,J0),IV0(I0,J0),
     1 IN(I0,J0,K1),IU(I1,J0,K1),IV(I0,J1,K1),IW(I0,J0,K0)
      COMMON/ZFS/Z(K0+K1),ODZ(K1),ODZW(K0)
C X-Y PLOTS
      K=1
C CALCULATE TOP LAYER VORTICITY XI POINTS
      CALL SETR(SCR(1,1,2),I0*J0,0.)
      TMP=7.*24.*3600.
      DO 10 J=2,J2
      DO 10 I=2,I2
 10   SCR(I,J,2)=(V(I+1,J,K)-V(I,J,K))*ODX-(U(I,J+1,K)-U(I,J,K))*ODY
      DO 12 J=1,J2
      DO 12 I=1,I2
 12   SCR(I+1,J+1,4)=.25*TMP*
     1 (SCR(I,J,2)+SCR(I+1,J,2)+SCR(I,J+1,2)+SCR(I+1,J+1,2))
      CALL XYPLOT('s','vorticity (per week)          ',SCR(1,1,4),K,K)
      DO 15 J=2,J1
      DO 15 I=2,I1
C CONVERT TO EQUIVALENT FREE SURFACE ANOMALY
 15   SCR(I,J,1)=P(I,J,K)/980.
      CALL XYPLOT('P','pressure-equivalent f.s.a.(cm)',SCR,K,K)
      CALL XYPLOT('u','longitudinal velocity (cm/sec)',U2(1,1,K),K,K)
      CALL XYPLOT('v','latitudinal velocity (cm/sec) ',V2(1,1,K),K,K)
      IF (ITF.NE.MXIT) RETURN

C CLIMATOLOGICAL FIELDS
      DO 35 J=2,J1
      DO 35 I=2,I1
 35   SCR(I,J,1)=XI2(I,J,2)/980.
      CALL XYPLOT('x','time average P (eq. fsa, cm)  ',SCR,1,1)
      DO 36 J=2,J1
      DO 36 I=2,I1
 36   SCR(I,J,1)=SQRT(XI2(I,J,1))/980.
      CALL XYPLOT('e','eddy rms surface elevation(cm)',SCR,1,1)
      END
C ----------------------------------------------------------------------
      SUBROUTINE COMXY(FLD,DAYS,IN,IR)
C SAVES MOVIE DATA
C ----------------------------------------------------------------------
      INCLUDE 'resolution.h'
      PARAMETER(IJ0=I0+J0,IJ1=IJ0-1,I1=I0-1,I2=I0-2,J1=J0-1,J2=J0-2,
     1 K1=K0-1,K2=K0-2)
      INTEGER*2 NFLD,IN
      COMMON/SCRTCH/SCR(I0,J0,K0+2),SCLN(IJ0,2),XI2(I0,J0,2)
      COMMON/FLOAT/NFLD(I0,J0)
      DIMENSION IN(IR,*),FLD(IR,*)
      CALL RANGE(FLD,SCLN,SCLN(1,2),IN,I0,2,2,I1,J1,
     1 ILO,JLO,IHI,JHI,FMIN,FMAX)
      FRNG=FMAX-FMIN
      RMIN=FMIN+1.E-5*FRNG
      RMAX=FMAX-1.E-5*FRNG
      IF ((RMAX-RMIN).EQ.0.) RETURN
 2    RF=9999./FRNG
C NFLD=9999.*(FLD-RMIN)/FRNG
      DO 11 J=2,J1
      DO 11 I=2,I1
 11   NFLD(I,J)=MIN(9999.,RF*(FLD(I,J)-RMIN)*IN(I,J))
      WRITE(21) DAYS,ILO,JLO,IHI,JHI,RMIN,RMAX,
     1 ((NFLD(I,J),I=2,I1),J=2,J1)
      END
C ----------------------------------------------------------------------
      SUBROUTINE XYPLOT(FN,FNAME,FLD,KL,KH)
C ----------------------------------------------------------------------
      INCLUDE 'resolution.h'
      PARAMETER(IJ0=I0+J0,IJ1=IJ0-1,I1=I0-1,I2=I0-2,J1=J0-1,J2=J0-2,
     1 K1=K0-1,K2=K0-2)
      CHARACTER FN*1,FNAME*30
      INTEGER*2 KB,IU0,IV0,IN,IU,IV,IW,NFLD
      COMMON/SCRTCH/SCR(I0,J0,K0+2),SCLN(IJ0,2),XI2(I0,J0,2)
      COMMON/FLOAT/NFLD(I0,J0)
      COMMON/BATHY/KB(I0,J0),IU0(I0,J0),IV0(I0,J0),
     1 IN(I0,J0,K1),IU(I1,J0,K1),IV(I0,J1,K1),IW(I0,J0,K0)
      COMMON/SCA/DX,DY,ODX,ODY,ODT,GB,PRN,DAYS,OFLTW,ITF
      DIMENSION FLD(I0,J0,*)
      DO 100 K=KL,KH
      KK=K-KL+1
      CALL RANGE(FLD(1,1,KK),SCLN,SCLN(1,2),IN(1,1,K),I0,2,2,I1,J1,
     1 ILO,JLO,IHI,JHI,FMIN,FMAX)
      WRITE(*,5) FN,FMIN,ILO,JLO,FMAX,IHI,JHI
 5    FORMAT(A1,': mn=',1PE9.2,' at (',I3,',',I3,'); mx=',1PE9.2,
     1 ' at (',I3,',',I3,')')
      FRNG=FMAX-FMIN
      RMIN=FMIN+1.E-5*FRNG
      RMAX=FMAX-1.E-5*FRNG
      IF ((RMAX-RMIN).EQ.0.) RETURN
 2    RF=9999./FRNG
C NFLD=9999.*(FLD-RMIN)/FRNG
      DO 11 J=2,J1
      DO 11 I=2,I1
 11   NFLD(I,J)=MIN(9999.,RF*(FLD(I,J,KK)-RMIN))
      IF (FN.EQ.'p') GO TO 100
      DO 12 J=2,J1
      DO 12 I=2,I1
 12   NFLD(I,J)=NFLD(I,J)*IN(I,J,K)
 100  WRITE(30) FN,FNAME,DAYS,K,ILO,JLO,IHI,JHI,RMIN,RMAX,
     1 ((NFLD(I,J),I=2,I1),J=2,J1)
      END
C ----------------------------------------------------------------------
      SUBROUTINE RANGE
     1 (FLD,SEGMN,SEGMX,IN,IR,IL,JL,IH,JH,ILO,JLO,IHI,JHI,FMIN,FMAX)
C VECTORIZED SEARCH FOR MAX'S AND MIN'S
C ----------------------------------------------------------------------
      INTEGER*2 IN
      DIMENSION FLD(IR,*),SEGMN(*),SEGMX(*),IN(IR,*)
      LBLK=1
      LAB=1
      IHM=IH-1
C SEARCH FOR MAXES
C
C INITIALIZE COLUMN MAXES
      DO 2 I=IL,IH
 2    SEGMX(I)=-1.E30
      IF (LBLK.EQ.0) GO TO 9
C
C SEARCH FOR COLUMN MAXES
C WITH ISLANDS
      DO 5 J=JL,JH
      DO 5 I=IL,IH
 5    SEGMX(I)=(1.-IN(I,J))*SEGMX(I)+IN(I,J)*MAX(SEGMX(I),FLD(I,J))
      GO TO 15
C WITHOUT ISLANDS
 9    DO 10 J=JL,JH
      DO 10 I=IL,IH
 10   SEGMX(I)=MAX(SEGMX(I),FLD(I,J))
C
C SEARCH FOR MAX OF COLUMN MAXES
 15   FMAX=SEGMX(IL)
      DO 20 I=IL,IHM
 20   FMAX=MAX(FMAX,SEGMX(I+1))
      IF (LAB.EQ.0) GO TO 50
C
C SEARCH FOR LOCATION OF MAX
      DO 29 I=IL,IH
 29   IF (SEGMX(I).EQ.FMAX) IHI=I
      DO 30 J=JL,JH
 30   IF (FLD(IHI,J).EQ.FMAX) JHI=J
C SEARCH FOR MINS
C
C INITIALIZE COLUMN MINS
 50   DO 52 I=IL,IH
 52   SEGMN(I)=1.E30
      IF (LBLK.EQ.0) GO TO 59
C
C SEARCH FOR COLUMN MINS
C WITH ISLANDS
      DO 55 J=JL,JH
      DO 55 I=IL,IH
 55   SEGMN(I)=(1.-IN(I,J))*SEGMN(I)+IN(I,J)*MIN(SEGMN(I),FLD(I,J))
      GO TO 65
C WITHOUT ISLANDS
 59   DO 60 J=JL,JH
      DO 60 I=IL,IH
 60   SEGMN(I)=MIN(SEGMN(I),FLD(I,J))
C
C SEARCH FOR MIN OF COLUMN MINS
 65   FMIN=SEGMN(IL)
      DO 70 I=IL,IHM
 70   FMIN=MIN(FMIN,SEGMN(I+1))
      IF (LAB.EQ.0) RETURN
C
C SEARCH FOR LOCATION OF MIN
      DO 79 I=IL,IH
 79   IF (SEGMN(I).EQ.FMIN) ILO=I
      DO 80 J=JL,JH
 80   IF (FLD(ILO,J).EQ.FMIN) JLO=J
      END
C ----------------------------------------------------------------------
      SUBROUTINE SETR(A,N,R)
C ----------------------------------------------------------------------
      DIMENSION A(*)
      DO 10 I=1,N
 10   A(I)=R
      END
C *****************
C ELLIPTIC SOLVER *
C *****************
C ----------------------------------------------------------------------
      SUBROUTINE REP(AX,AY,BB,CX,CY,RINV,RINV1,DUM0,DUM1,DUM2,F,H,X,IE,
     1 M0,M2,NBLK)
C ----------------------------------------------------------------------
CIBM  REAL*8 RINV,RINV1,DUM0,DUM1,DUM2,X,H,ROW
      REAL*8 RINV,RINV1,DUM0,DUM1,DUM2,X,H
      INCLUDE 'resolution.h'
      DIMENSION AX(M2,*),AY(M2,*),BB(M2,*),CX(M2,*),CY(M2,*),
     1 RINV(M2,M2,*),RINV1(M2,M2,*),H(M0,*),IE(*),DUM0(M2,*),DUM1(*),
     2 DUM2(*),F(M2,*),X(M0,*)
CIBM
C     DIMENSION ROW(I0)
      JS=1
      DO 150 NB=1,NBLK
      JF=IE(NB)-2
      DO 105 J=JS,JF
      DO 105 I=1,M2
 105  X(I+1,J+2)=(F(I,J)-AX(I,J)*X(I,J+1)-AY(I,J)*X(I+1,J)-BB(I,J)*
     1 X(I+1,J+1)-CX(I,J)*X(I+2,J+1))/CY(I,J)
CIBM
C     DO 104 I=1,M2
C104  ROW(I+1)=(F(I,J)-AX(I,J)*X(I,J+1)-AY(I,J)*X(I+1,J)-BB(I,J)*
C    1 X(I+1,J+1)-CX(I,J)*X(I+2,J+1))/CY(I,J)
C     DO 105 I=1,M2
C105  X(I+1,J+2)=ROW(I+1)
      IF (NB.EQ.NBLK) GO TO 150
      J=IE(NB)-1
      DO 115 I=1,M2
 115  DUM1(I)=F(I,J)-AX(I,J)*X(I,J+1)-AY(I,J)*X(I+1,J)-BB(I,J)*
     1 X(I+1,J+1)-CX(I,J)*X(I+2,J+1)-CY(I,J)*X(I+1,J+2)
      J=IE(NB)
      DO 120 N=1,M2
      DUM2(N)=0.
      DO 118 M=1,M2
 118  DUM2(N)=DUM2(N)+DUM1(M)*RINV1(M,N,NB)
      DUM0(N,NB)=X(N+1,J)
 120  X(N+1,J)=X(N+1,J)-DUM2(N)
 150  JS=IE(NB)
      DO 300 NBS=1,NBLK
      NB=NBLK-NBS+1
      JS=1
      IF (NB.NE.1) JS=IE(NB-1)
      JF=IE(NB)-2
      IF (NB.EQ.NBLK) GO TO 201
      J=IE(NB)
      DO 200 N=1,M2
 200  X(N+1,J)=DUM0(N,NB)
 201  N=IE(NB)
      DO 202 J=JS,N
      DO 202 I=1,M0
 202  H(I,J)=0.
      J=IE(NB)-1
      DO 210 I=1,M2
 210  DUM1(I)=F(I,J)-AX(I,J)*X(I,J+1)-AY(I,J)*X(I+1,J)-BB(I,J)*
     1 X(I+1,J+1)-CX(I,J)*X(I+2,J+1)-CY(I,J)*X(I+1,J+2)
      DO 220 N=1,M2
      DUM2(N)=0.
      DO 218 M=1,M2
 218  DUM2(N)=DUM2(N)+DUM1(M)*RINV(M,N,NB)
      H(N+1,JS+1)=DUM2(N)
 220  X(N+1,JS+1)=X(N+1,JS+1)+DUM2(N)
      IF (NB.EQ.1) GO TO 250
      DO 230 M=1,M2
 230  DUM1(M)=H(M+1,JS+1)*CY(M,JS-1)
      J=IE(NB-1)
      DO 240 N=1,M2
      DUM2(N)=0.
      DO 238 M=1,M2
 238  DUM2(N)=DUM2(N)+DUM1(M)*RINV1(M,N,NB-1)
 240  H(N+1,J)=DUM2(N)
 250  DO 300 J=JS,JF
      DO 300 I=1,M2
      H(I+1,J+2)=(-AX(I,J)*H(I,J+1)-AY(I,J)*H(I+1,J)-BB(I,J)*
     1 H(I+1,J+1)-CX(I,J)*H(I+2,J+1))/CY(I,J)
CIBM
C     DO 298 I=1,M2
C298  ROW(I+1)=(-AX(I,J)*H(I,J+1)-AY(I,J)*H(I+1,J)-BB(I,J)*
C    1 H(I+1,J+1)-CX(I,J)*H(I+2,J+1))/CY(I,J)
C     DO 299 I=1,M2
C299  H(I+1,J+2)=ROW(I+1)
C     DO 300 I=1,M2
 300  X(I+1,J+2)=X(I+1,J+2)+H(I+1,J+2)
      END
C ****************
C INITIALIZATION *
C ****************
C ----------------------------------------------------------------------
      SUBROUTINE INITFS
C INITIALIZE ALL CONTROLLING ARRAYS AND DERIVED SCALARS FOR FS
C (SCALAR CONTROL PARAMETERS ARE INITIALIZED IN BLOCK DATA PROGRAM AT END
C OF THIS FILE)
C ----------------------------------------------------------------------
      INCLUDE 'resolution.h'
      PARAMETER(IJ0=I0+J0,IJ1=IJ0-1,I1=I0-1,I2=I0-2,J1=J0-1,J2=J0-2,
     1 K1=K0-1,K2=K0-2,NB1=NB0-1)
      REAL*8 RINV,RINV1,DUM0,DUM1,DUM2,X,H
      CHARACTER CASE*5,DSCRIB*63
      CHARACTER*10 FORM
      INTEGER*2 KB,IU0,IV0,IN,IU,IV,IW
      COMMON U1(I0,J0,K1),U2(I0,J0,K1),V1(I0,J0,K1),V2(I0,J0,K1),
     1 P(I0,J0,K1),ULF(I0,J0,K1),VLF(I0,J0,K1),DMX(I1,J0,K1),
     2 DMY(I0,J1,K1)
      COMMON/ADV/U(I1,J0,K1),V(I0,J1,K1),PX(I0,J0),PY(I0,J0)
      COMMON/CONTRO/DT,TLZ,DM0,DE0,DMZ0,FLTW,AV,
     1 DAODT,ITFDAY,LRSTRT,MXIT,MOVI
      COMMON/SCRTCH/SCR(I0,J0,K0+2),SCLN(IJ0,2),XI2(I0,J0,2)
      COMMON/SCA/DX,DY,ODX,ODY,ODT,GB,PRN,DAYS,OFLTW,ITF
      COMMON/SEVP/RINV(I2,I2,NB0),RINV1(I2,I2,NB1),DUM0(I2,NB1),
     1 DUM1(I2),DUM2(I2),X(I0,J0),H(I0,J0),AL(I2,J2),AB(I2,J2),
     2 AC(I2,J2),AR(I2,J2),AT(I2,J2),S(I2,J2)
      COMMON/BATHY/KB(I0,J0),IU0(I0,J0),IV0(I0,J0),
     1 IN(I0,J0,K1),IU(I1,J0,K1),IV(I0,J1,K1),IW(I0,J0,K0)
      COMMON/ZFS/Z(K0+K1),ODZ(K1),ODZW(K0)
      COMMON/LPI/M2,M6,MVI,IE(NB0)
      COMMON/TITLE/CASE,DSCRIB
 2    FORMAT('CASE ',A5,' (',A63,')'/' LRSTRT  MXIT   I0   J0   K0'
     1 /I6,I7,3I5/8X,'DT',6X,'FLTW',7X,'TLX',7X,'TLY',7X,'TLZ'
     2 /1P,5(1X,E9.2)/7X,'DM0',7X,'DE0',6X,'DMZ0'/1P,3(1X,E9.2))
 3    FORMAT('CORIOLIS PARAMETER'/(7(1X,1PE10.3)))
 4    FORMAT('LOGICAL SURFACE SHAPE (IN(I,J,1))'/(106I1))
 5    FORMAT(1X,'K',2X,'Z(2K-1)',3X,'ODZ(K)',3X,'ODZW(K)'/
     1 (I2,3(1X,1PE9.2)))
 6    FORMAT(2I4/4F13.7,A10)
 7    FORMAT(5E15.7)
C ---------------------
C OPEN INPUT DATA FILES
C ---------------------
      OPEN(9,file='PREP/DATA/RUNDATA',form='unformatted')
C Z-LEVELS AND LOGICAL DEPTH ARRAY (KB)
      OPEN(60,file='PREP/DATA/ZKB',form='unformatted')
      OPEN(61,file='PREP/DATA/inflow',form='unformatted')
C INITIAL AND BOUNDARY FIELDS
      OPEN(99,file='PREP/DATA/EVP',form='unformatted')
      REWIND 9
      REWIND 60
      REWIND 61
      REWIND 99
C -------------------------------------------------
C METRICS, Z-LEVELS (Z), AND LOGICAL DEPTH ARRAY KB
C KB may be made redundant in 2-d problem
C -------------------------------------------------
      READ(60) TLZ,Z,ODZ,ODZW,KB,IN,IU,IV,IW,IU0,IV0
      READ(9) CASE,DSCRIB,DT,TLX,TLY,TLZ,DM0,DE0,DMZ0,
     1 FLTW,DAODT,DXDEG,DYDEG,ODT,GB,DX,DY,ODX,ODY,OFLTW,PRN,
     2 LRSTRT,MXIT,M2,M6,LOPEN,LMOVI,MVI,F
      WRITE(14,2) CASE,DSCRIB,LRSTRT,MXIT,I0,J0,K0,DT,
     1 FLTW,TLX,TLY,TLZ,DM0,DE0,DMZ0

C EVP SOLVER DATA
      READ(99) AL,AR,AB,AT,AC,RINV,RINV1,IE
      TMP=SQRT(ODX*ODY)
      DM0=DM0*TMP
      DE0=DE0*TMP
      LWIND=0

C set initial and southern boundary inflow conditions
C northern boundary is open, adjusted to match total inflow using upwind
C based approach
      READ(61) V,V1,V2,VLF
      FLTW=.5*FLTW

      IF (LRSTRT.EQ.0) GO TO 100
C ------------
C RESTART DATA
C ------------
      READ(19) ITF,DAYS,AV,(X(I,2),I=2,I1),U1,U2,V1,V2,ULF,VLF,U,V,XI2
      WRITE(14,99) ITF
      WRITE(14,99) ITF
      WRITE(*,99) ITF
 99   FORMAT('RESTART DATA READ FOR TIME STEP ',I6)
 100  CONTINUE
      WRITE(14,3) F
      DO 270 J=1,J0
 270  WRITE(14,274) J,(KB(I,J),I=1,I0)
 274  FORMAT('KB AT J=',I3/(20I3))
      WRITE(30) CASE,DSCRIB,LRSTRT,MXIT,I0,J0,K0,IN,ODX,ODY,ODZ,Z
C DEPTH
 89   READ(60) ((SCR(I,J,2),I=1,I0),J=1,J0)
      CALL XYPLOT('Z','depth (kilometers)            ',SCR(1,1,2),1,1)
      IF (LRSTRT.NE.0) RETURN
      DAYS=0.
      AV=0.
      CALL SETR(XI2,2*I0*J0,0.)

C SHOW INITIAL FIELDS
      END
